/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.jmx.MBeanServerNotFoundException;

public final class JbossJmxServerLocator
extends AbstractFactoryBean<MBeanServer> {
    public static final String JBOSS_DOMAIN = "jboss";
    private static final Logger LOGGER = LoggerFactory.getLogger(JbossJmxServerLocator.class);

    protected MBeanServer createInstance() throws Exception {
        return this.choose(MBeanServerFactory.findMBeanServer(null));
    }

    MBeanServer choose(List<MBeanServer> allServers) throws MBeanServerNotFoundException {
        if (allServers.isEmpty()) {
            throw new MBeanServerNotFoundException("No MBeanServers in JVM");
        }
        for (MBeanServer s : allServers) {
            if (!s.getDefaultDomain().equals(JBOSS_DOMAIN)) continue;
            LOGGER.info("Found JBoss's MBeanServer");
            return s;
        }
        LOGGER.warn("No JBoss MBeanServer found, using first in list (out of total of " + allServers.size() + ")");
        return allServers.get(0);
    }

    public Class<MBeanServer> getObjectType() {
        return MBeanServer.class;
    }
}

