/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.spring;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.core.StringUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0007J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0019H\u0007J \u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0019H\u0007J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006H\u0007J\u001a\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006H\u0007J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006H\u0007J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006H\u0007J\u0010\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u000202H\u0007J\u0010\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u000205H\u0002J\u001a\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u00192\b\u00108\u001a\u0004\u0018\u00010\u0019H\u0007J&\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u00192\b\b\u0002\u00109\u001a\u00020\u001c2\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u0019H\u0007J\u0010\u0010:\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0019H\u0007J\u001a\u0010;\u001a\u0004\u0018\u00010\u00062\u0006\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\rH\u0002J \u0010>\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Luk/ac/warwick/util/core/spring/FileUtils;", "", "()V", "BYTES_IN_KB", "", "BYTE_LABEL", "", "GIGA_BYTE_LABEL", "KB_IN_MB", "KILO_BYTE_LABEL", "LOGGER", "Lorg/slf4j/Logger;", "MAX_GB_TO_SHOW_DECIMALS", "", "MAX_MB_TO_SHOW_DECIMALS", "MB_IN_GB", "MEGA_BYTE_LABEL", "TEMP_FILE_RETRIES", "safeFilenameCollapsibleChars", "Lkotlin/text/Regex;", "convertToSafeFileName", "originalName", "copy", "", "source", "Ljava/io/File;", "target", "recurse", "", "createFile", "theSuggestedName", "directory", "theContents", "Ljava/io/InputStream;", "createOrLoadFile", "parent", "fileName", "extensionMatches", "filename", "extension", "generateRandomFile", "filePrefix", "getExtension", "s", "getFileName", "url", "getFileNameWithoutExtension", "getLowerCaseExtension", "getReadableFileSize", "sizeInBytes", "", "isValidForFileName", "c", "", "recursiveDelete", "file", "deletionBin", "strict", "recursiveOutput", "roundAndFormat", "size", "maxShowDecimals", "sanityCheck", "warwickutils-core"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\nuk/ac/warwick/util/core/spring/FileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,415:1\n1#2:416\n3864#3:417\n4387#3,2:418\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\nuk/ac/warwick/util/core/spring/FileUtils\n*L\n268#1:417\n268#1:418,2\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    public static final String BYTE_LABEL = "B";
    @NotNull
    public static final String KILO_BYTE_LABEL = "KB";
    @NotNull
    public static final String MEGA_BYTE_LABEL = "MB";
    @NotNull
    public static final String GIGA_BYTE_LABEL = "GB";
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Regex safeFilenameCollapsibleChars;
    private static final int TEMP_FILE_RETRIES = 5;
    private static final float MAX_MB_TO_SHOW_DECIMALS = 10.0f;
    private static final float MAX_GB_TO_SHOW_DECIMALS = 10.0f;
    private static final int BYTES_IN_KB = 1024;
    private static final int KB_IN_MB = 1024;
    private static final int MB_IN_GB = 1024;

    private FileUtils() {
    }

    @JvmStatic
    public static final void recursiveDelete(@NotNull File file, @Nullable File deletionBin) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileUtils.recursiveDelete(file, true, deletionBin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @JvmOverloads
    public static final void recursiveDelete(@NotNull File file, boolean strict, @Nullable File deletionBin) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) {
            if (LOGGER.isDebugEnabled()) {
                String string2 = "Directory contains files (pre-delete):";
                string2 = string2 + FileUtils.recursiveOutput(file);
                LOGGER.debug(string2);
            }
            File[] fileArray = file.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
            for (File child : fileArray) {
                Intrinsics.checkNotNull((Object)child);
                FileUtils.recursiveDelete(child, strict, deletionBin);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting " + file);
        }
        if (bl = file.delete()) return;
        if (strict) {
            LOGGER.info("Could not delete the " + (file.isDirectory() ? "directory" : "file") + ' ' + file);
            if (LOGGER.isDebugEnabled() && file.isDirectory()) {
                if (file.list().length == 0) {
                    LOGGER.debug("Directory contains no files anymore though");
                } else {
                    String logMessage = "Directory contains files:";
                    logMessage = logMessage + FileUtils.recursiveOutput(file);
                    LOGGER.debug(logMessage);
                }
            }
            if (deletionBin == null || !file.isDirectory()) throw new IllegalStateException("Cannot delete " + file);
            if (!(deletionBin.isDirectory() && deletionBin.exists())) {
                boolean $i$a$-require-FileUtils$recursiveDelete$22 = false;
                String $i$a$-require-FileUtils$recursiveDelete$22 = "Deletion bin " + deletionBin + " must be an existing directory";
                throw new IllegalArgumentException($i$a$-require-FileUtils$recursiveDelete$22.toString());
            }
            File renameToFile = new File(deletionBin, file.getName() + System.currentTimeMillis());
            if (!(!renameToFile.exists())) {
                boolean $i$a$-check-FileUtils$recursiveDelete$42 = false;
                String $i$a$-check-FileUtils$recursiveDelete$42 = "Could not rename directory to " + renameToFile + " - file already exists";
                throw new IllegalStateException($i$a$-check-FileUtils$recursiveDelete$42.toString());
            }
            boolean success = file.renameTo(renameToFile);
            if (!success) {
                boolean bl2 = false;
                String string = "Failed to rename directory to " + renameToFile;
                throw new IllegalStateException(string.toString());
            }
            renameToFile.deleteOnExit();
            return;
        } else {
            file.deleteOnExit();
            LOGGER.info("Could not delete the file " + file + ", marked to delete on exit");
        }
    }

    public static /* synthetic */ void recursiveDelete$default(File file, boolean bl, File file2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            file2 = null;
        }
        FileUtils.recursiveDelete(file, bl, file2);
    }

    @JvmStatic
    public static final void copy(@NotNull File source, @NotNull File target, boolean recurse) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        INSTANCE.sanityCheck(source, target, recurse);
        if (source.isDirectory()) {
            File[] filesInDir = source.listFiles();
            if (!target.mkdirs() && !target.exists()) {
                throw new IOException("Cannot create " + target);
            }
            Intrinsics.checkNotNull((Object)filesInDir);
            for (File child : filesInDir) {
                if (!child.isFile() && !recurse) continue;
                Intrinsics.checkNotNull((Object)child);
                FileUtils.copy(child, new File(target, child.getName()), recurse);
            }
        } else {
            if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                throw new IOException("Cannot create " + target);
            }
            FileCopyUtils.copy((File)source, (File)target);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sanityCheck(File source, File target, boolean recurse) {
        if (!source.exists()) {
            boolean $i$a$-require-FileUtils$sanityCheck$52 = false;
            String $i$a$-require-FileUtils$sanityCheck$52 = "The source " + source + " must exist.";
            throw new IllegalArgumentException($i$a$-require-FileUtils$sanityCheck$52.toString());
        }
        if (!(!target.exists() || target.isDirectory())) {
            boolean $i$a$-require-FileUtils$sanityCheck$62 = false;
            String $i$a$-require-FileUtils$sanityCheck$62 = "The target " + target + " must not exist.";
            throw new IllegalArgumentException($i$a$-require-FileUtils$sanityCheck$62.toString());
        }
        if (!(!target.exists() || source.isDirectory() == target.isDirectory())) {
            boolean $i$a$-require-FileUtils$sanityCheck$72 = false;
            String string = "Source '%s' and target '%s' must both be directories or both be files";
            Object[] objectArray = new Object[]{source, target};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String $i$a$-require-FileUtils$sanityCheck$72 = string2;
            throw new IllegalArgumentException($i$a$-require-FileUtils$sanityCheck$72.toString());
        }
        if (!recurse) return;
        String string = target.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        if (!StringsKt.startsWith$default((String)string, (String)(source.getAbsolutePath() + '/'), (boolean)false, (int)2, null)) {
            return;
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = false;
        String string3 = "Target '%s' cannot be a descendant of source '%s'";
        Object[] objectArray = new Object[]{target, source};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        String string5 = string4;
        throw new IllegalArgumentException(string5.toString());
    }

    @JvmStatic
    @NotNull
    public static final String getFileName(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        File file = new File(url);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getFileNameWithoutExtension(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = StringUtils.safeSubstring(s, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"safeSubstring(...)");
        int indexOfLastDot = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (indexOfLastDot < 0) {
            return s;
        }
        String string2 = s.substring(0, indexOfLastDot + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    private final String getExtension(String s) {
        String string = StringUtils.safeSubstring(s, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"safeSubstring(...)");
        int indexOfLastDot = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (indexOfLastDot < 0) {
            return "";
        }
        String string2 = s.substring(indexOfLastDot + 2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String getLowerCaseExtension(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String string = INSTANCE.getExtension(filename);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @JvmStatic
    public static final boolean extensionMatches(@NotNull String filename, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        CharSequence charSequence = extension;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string = charSequence.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        charSequence = string;
        Regex regex = new Regex("[^.]*\\.");
        String string2 = "";
        String compareExtension = regex.replace(charSequence, string2);
        return StringsKt.equals((String)FileUtils.getLowerCaseExtension(filename), (String)compareExtension, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Contract(value="!null -> !null; null -> null")
    @Nullable
    public static final String convertToSafeFileName(@Nullable String originalName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        CharSequence charSequence = originalName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return originalName;
        }
        String normalised = Normalizer.normalize(originalName, Normalizer.Form.NFKD);
        Intrinsics.checkNotNull((Object)normalised);
        String string = normalised;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        File file = new File(string2);
        String s = file.getName();
        Intrinsics.checkNotNull((Object)s);
        String fileName = FileUtils.getFileNameWithoutExtension(s);
        String extension = FileUtils.getLowerCaseExtension(s);
        StringBuffer fileNameSB = new StringBuffer();
        char[] cArray = fileName.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            if (!INSTANCE.isValidForFileName(c)) continue;
            fileNameSB.append(c);
        }
        while (((CharSequence)fileNameSB).length() > 0 && fileNameSB.charAt(0) == '.') {
            fileNameSB.deleteCharAt(0);
        }
        String string3 = fileNameSB.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String baseName = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        char[] cArray2 = extension.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
        char[] cArray3 = cArray2;
        boolean $i$f$filter = false;
        Regex regex = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!INSTANCE.isValidForFileName((char)it)) continue;
            destination$iv$iv.add(Character.valueOf((char)element$iv$iv));
        }
        String cleanedExtension = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null))).toString();
        String joinedName = StringUtils.hasText(cleanedExtension) ? baseName + '.' + cleanedExtension : baseName;
        CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)joinedName)).toString();
        regex = safeFilenameCollapsibleChars;
        String string4 = "-";
        return regex.replace(charSequence2, string4);
    }

    private final boolean isValidForFileName(char c) {
        return Intrinsics.compare((int)c, (int)97) >= 0 && Intrinsics.compare((int)c, (int)122) <= 0 || Intrinsics.compare((int)c, (int)65) >= 0 && Intrinsics.compare((int)c, (int)90) <= 0 || Intrinsics.compare((int)c, (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0 || c == '_' || c == '-' || c == ' ' || c == '.';
    }

    @JvmStatic
    @NotNull
    public static final File createOrLoadFile(@NotNull File parent, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!parent.isDirectory()) {
            boolean $i$a$-check-FileUtils$createOrLoadFile$32 = false;
            String $i$a$-check-FileUtils$createOrLoadFile$32 = "Parent " + parent + " must be a directory";
            throw new IllegalStateException($i$a$-check-FileUtils$createOrLoadFile$32.toString());
        }
        File file = new File(parent, fileName);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    boolean bl = false;
                    String string = "Cannot create file " + file;
                    throw new IllegalStateException(string.toString());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create file " + file);
            }
        }
        return file;
    }

    @JvmStatic
    @NotNull
    public static final String recursiveOutput(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            return "";
        }
        String output = '\n' + file.getPath();
        if (file.isDirectory()) {
            File[] subfiles = file.listFiles();
            Intrinsics.checkNotNull((Object)subfiles);
            for (File subfile : subfiles) {
                StringBuilder stringBuilder = new StringBuilder().append(output);
                Intrinsics.checkNotNull((Object)subfile);
                output = stringBuilder.append(FileUtils.recursiveOutput(subfile)).toString();
            }
        } else {
            output = output + ' ';
            output = output + file.length();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final File createFile(@NotNull String theSuggestedName, @NotNull InputStream theContents, @NotNull File directory) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)theSuggestedName, (String)"theSuggestedName");
        Intrinsics.checkNotNullParameter((Object)theContents, (String)"theContents");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File file = FileUtils.createFile(theSuggestedName, directory);
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            int n;
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            try {
                n = FileCopyUtils.copy((InputStream)theContents, (OutputStream)fos);
            }
            catch (IOException e) {
                throw new IllegalStateException("cannot copy contents [" + theContents + "] into " + file, e);
            }
            int n2 = n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return file;
    }

    @JvmStatic
    @NotNull
    public static final File createFile(@NotNull String theSuggestedName, @NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)theSuggestedName, (String)"theSuggestedName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        if (!(directory.exists() || directory.mkdirs())) {
            boolean bl = false;
            String string = "Unable to create directories for temporary file storage";
            throw new IllegalStateException(string.toString());
        }
        int n = 5;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            File file = INSTANCE.generateRandomFile(theSuggestedName, directory);
            if (file.exists()) continue;
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create file " + file, e);
            }
            return file;
        }
        throw new IllegalStateException("Cannot create file based on " + theSuggestedName);
    }

    private final File generateRandomFile(String filePrefix, File directory) {
        String fileName = filePrefix + System.nanoTime();
        String string = FileUtils.convertToSafeFileName(fileName);
        Intrinsics.checkNotNull((Object)string);
        fileName = string;
        return new File(directory, fileName + ".tmp");
    }

    @JvmStatic
    @NotNull
    public static final String getReadableFileSize(double sizeInBytes) {
        String sizeString = null;
        String units = BYTE_LABEL;
        if (sizeInBytes < 1024.0) {
            sizeString = "" + Math.round(sizeInBytes);
        } else {
            units = KILO_BYTE_LABEL;
            double sizeInKb = sizeInBytes / 1024.0;
            if (sizeInKb < 1024.0) {
                sizeString = "" + Math.round(sizeInKb);
            } else {
                units = MEGA_BYTE_LABEL;
                double sizeInMb = sizeInKb / (double)1024;
                if (sizeInMb < 1024.0) {
                    sizeString = "" + INSTANCE.roundAndFormat(sizeInMb, 10.0f);
                } else {
                    units = GIGA_BYTE_LABEL;
                    double sizeInGb = sizeInMb / (double)1024;
                    sizeString = "" + INSTANCE.roundAndFormat(sizeInGb, 10.0f);
                }
            }
        }
        return sizeString + ' ' + units;
    }

    private final String roundAndFormat(double size, float maxShowDecimals) {
        if (size < (double)maxShowDecimals) {
            return new DecimalFormat("#.0").format(size);
        }
        return "" + Math.round(size);
    }

    @JvmStatic
    @JvmOverloads
    public static final void recursiveDelete(@NotNull File file, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileUtils.recursiveDelete$default(file, strict, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void recursiveDelete(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileUtils.recursiveDelete$default(file, false, null, 6, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(FileUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        safeFilenameCollapsibleChars = new Regex("[\\s-]+");
    }
}

