/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.scheduling;

import java.time.Instant;
import uk.ac.warwick.util.core.DateTimeUtils;

public class QuartzScheduler {
    private String schedulerName;
    private String instanceName;
    private long checkinTimeInMillis;
    private int checkinIntervalInMillis;

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public long getCheckinTimeInMillis() {
        return this.checkinTimeInMillis;
    }

    public void setCheckinTimeInMillis(long checkinTimeInMillis) {
        this.checkinTimeInMillis = checkinTimeInMillis;
    }

    public int getCheckinIntervalInMillis() {
        return this.checkinIntervalInMillis;
    }

    public void setCheckinIntervalInMillis(int checkinIntervalInMillis) {
        this.checkinIntervalInMillis = checkinIntervalInMillis;
    }

    public long getAge() {
        return Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION).toEpochMilli() - this.checkinTimeInMillis;
    }

    public boolean isStale() {
        return Instant.ofEpochMilli(this.checkinTimeInMillis).plusMillis(this.checkinIntervalInMillis).plusSeconds(10L).isBefore(Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuartzScheduler that = (QuartzScheduler)o;
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        return this.instanceName != null ? this.instanceName.equals(that.instanceName) : that.instanceName == null;
    }

    public int hashCode() {
        int result = this.schedulerName != null ? this.schedulerName.hashCode() : 0;
        result = 31 * result + (this.instanceName != null ? this.instanceName.hashCode() : 0);
        return result;
    }
}

