/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core.filesize;

final class Size {
    private static final int MULTIPLIER = 1024;
    private static final int K = 1024;
    private static final int M = 0x100000;
    private static final int G = 0x40000000;
    private long bytes;

    Size(long b) {
        this.bytes = b;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getKibibytes() {
        return this.bytes / 1024L;
    }

    public long getMibibytes() {
        return this.bytes / 0x100000L;
    }

    public long getGibibytes() {
        return this.bytes / 0x40000000L;
    }

    public static Size bytes(long b) {
        return new Size(b);
    }

    public static Size kibibytes(long kib) {
        return new Size(kib * 1024L);
    }

    public static Size mibibytes(long mib) {
        return new Size(mib * 0x100000L);
    }

    public static Size gibibytes(long gib) {
        return new Size(gib * 0x40000000L);
    }
}

