/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern TRAILING_SPACE_PATTERN = Pattern.compile("\\s+$", 32);
    private static final Pattern LEADING_SPACE_PATTERN = Pattern.compile("^\\s+", 32);
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final int HIGH_CHAR = 127;
    private static final String ESCAPED_AMP_ENTITIES = "&amp;(#x[0-9A-Fa-f]+|#[0-9]+|[A-Za-z0-9]+);";

    private StringUtils() {
    }

    public static String create(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return new String(bytes, DEFAULT_CHARSET);
    }

    @Deprecated
    public static byte[] create(String s) {
        return StringUtils.nullGuard(s).getBytes(DEFAULT_CHARSET);
    }

    public static String join(String[] strings, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            buffer.append(strings[i]);
            if (i + 1 >= len) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String join(Collection<String> s, String delimiter) {
        return StringUtils.join(s, delimiter, false);
    }

    public static String join(Collection<String> s, String delimiter, boolean trim) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = s.iterator();
        while (iter.hasNext()) {
            String string = iter.next();
            if (trim) {
                string = string.trim();
            }
            builder.append(string);
            if (!iter.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String convertToString(Collection<String> keywords, String seperator) {
        return StringUtils.join(keywords, seperator, true);
    }

    public static List<String> convertCommaDelimitedStringToList(String keywords) {
        String[] commaSeperatedElements;
        ArrayList<String> results = new ArrayList<String>();
        if (!StringUtils.hasText(keywords)) {
            return results;
        }
        for (String s : commaSeperatedElements = keywords.split(",")) {
            if (!StringUtils.hasText(s)) continue;
            results.add(s.trim());
        }
        return results;
    }

    public static List<String> convertUnescapedCommaDelimitedStringToList(String keywords) {
        String[] commaSeperatedElements;
        ArrayList<String> results = new ArrayList<String>();
        if (!StringUtils.hasText(keywords)) {
            return results;
        }
        for (String s : commaSeperatedElements = keywords.split("(?<!\\\\),")) {
            if (!StringUtils.hasText(s)) continue;
            results.add(s.replace("\\,", ",").trim());
        }
        return results;
    }

    public static String safeSubstring(String s, int proposedStart, int proposedEnd) {
        if (s == null || s.length() == 0) {
            return "";
        }
        String result = "";
        if (proposedStart > proposedEnd) {
            result = "";
        } else if (proposedEnd < 0) {
            result = "";
        } else {
            int start = proposedStart < 0 ? 0 : proposedStart;
            start = start > s.length() ? s.length() : start;
            int end = proposedEnd > s.length() ? s.length() : proposedEnd;
            result = s.substring(start, end);
        }
        return result;
    }

    public static String safeSubstring(String s, int proposedStart) {
        String result;
        if (s == null || s.length() == 0) {
            return "";
        }
        int l = s.length();
        if (proposedStart > l) {
            result = "";
        } else {
            int start = proposedStart < 0 ? 0 : proposedStart;
            start = start > l ? l : start;
            result = s.substring(start);
        }
        return result;
    }

    public static String nullGuard(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String substringBetween(String text, String startString, String endString) {
        String t = text;
        int start = t.indexOf(startString);
        if (start == -1) {
            return null;
        }
        int end = t.indexOf(endString, start += startString.length());
        String result = end == -1 ? t.substring(start) : t.substring(start, end);
        return result;
    }

    public static int determineEndOfCommon(String firstString, String secondString) {
        char[] a = firstString.toCharArray();
        char[] b = secondString.toCharArray();
        int longestString = Math.max(a.length, b.length);
        int i = 0;
        for (i = 0; i < longestString && i < a.length && i < b.length && a[i] == b[i]; ++i) {
        }
        return i;
    }

    public static String compactWhitespace(String text) {
        return text.replaceAll("\\s+", " ");
    }

    public static boolean containsSpaceInsensitive(String srcString, String searchString) {
        return StringUtils.compactWhitespace(srcString.trim()).contains(StringUtils.compactWhitespace(searchString.trim()));
    }

    public static boolean equalsSpaceInsensitive(String aString, String bString) {
        return StringUtils.compactWhitespace(aString.trim()).equals(StringUtils.compactWhitespace(bString.trim()));
    }

    public static String htmlEscapeHighCharacters(String input) {
        StringReader reader = new StringReader(input);
        StringBuilder sb = new StringBuilder(input.length());
        int c = 0;
        try {
            while ((c = reader.read()) != -1) {
                if (c > 127) {
                    if (Character.isHighSurrogate((char)c)) {
                        int point = Character.toCodePoint((char)c, (char)reader.read());
                        sb.append("&#" + point + ";");
                    } else {
                        sb.append("&#" + c + ";");
                    }
                } else {
                    sb.append((char)c);
                }
                if (c != -1) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sb.toString();
    }

    public static String htmlEscapeSpecialCharacters(String input) {
        return input.replaceAll("&", "&amp;").replaceAll(ESCAPED_AMP_ENTITIES, "&$1;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String ltrim(String source) {
        return LEADING_SPACE_PATTERN.matcher(source).replaceAll("");
    }

    public static String rtrim(String source) {
        return TRAILING_SPACE_PATTERN.matcher(source).replaceAll("");
    }

    public static boolean hasLength(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean hasText(String s) {
        return s != null && s.trim().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        try {
            int byteCount = 0;
            char[] buffer = new char[8192];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out.toString();
    }

    public static String asciiLowerCase(String input) {
        char[] charArray = input.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char character = charArray[i];
            if (character < 'A' || character > 'Z') continue;
            charArray[i] = Character.toLowerCase(character);
        }
        return new String(charArray);
    }
}

