/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.core.HtmlCharacterEntityReferences;
import uk.ac.warwick.util.core.StringUtils;

public final class HtmlUtils {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String htmlEscape(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            String reference = characterEntityReferences.convertToReference(character);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeNonAscii(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (character > '\u007f') {
                String reference = characterEntityReferences.convertToReference(character);
                if (reference != null) {
                    escaped.append(reference);
                    continue;
                }
                escaped.append("&#x");
                escaped.append(Integer.toString(character, 16));
                escaped.append(";");
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscape(char character) {
        return characterEntityReferences.convertToReference(character);
    }

    public static Set<String> extractContentRegex(String content, String start, String end) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        Pattern p = Pattern.compile("(?ism)" + start + "(.*?)" + end);
        Matcher m = p.matcher(content);
        while (m.find()) {
            results.add(m.group(0));
        }
        m.replaceAll("");
        return results;
    }

    public static List<String> extractContent(String content, String start, String end) {
        return HtmlUtils.extractContent(content, start, end, 0);
    }

    public static String replaceContent(String parentContent, String newContent, String start, String end) {
        ContentFinder cf = new ContentFinder();
        cf.doFind(parentContent, start, end, 0);
        int startTagStart = cf.getStartTagStart();
        int startTagEnd = cf.getStartTagEnd();
        int endTagStart = cf.getEndTagStart();
        int endTagEnd = cf.getEndTagEnd();
        if (startTagStart == -1 || startTagEnd == -1 || endTagStart == -1 || endTagEnd == -1) {
            return newContent;
        }
        StringBuilder result = new StringBuilder();
        result.append(parentContent.substring(0, startTagEnd + 1));
        result.append(newContent);
        result.append(parentContent.substring(endTagStart));
        return result.toString();
    }

    private static List<String> extractContent(String content, String start, String end, int startAtIndex) {
        ArrayList<String> results = new ArrayList<String>();
        String lowerContent = StringUtils.asciiLowerCase(content);
        ContentFinder cf = new ContentFinder();
        cf.doFind(content, start, end, startAtIndex);
        int startTagStart = cf.getStartTagStart();
        int startTagEnd = cf.getStartTagEnd();
        int endTagStart = cf.getEndTagStart();
        int endTagEnd = cf.getEndTagEnd();
        if (startTagStart == -1 || startTagEnd == -1 || endTagStart == -1 || endTagEnd == -1) {
            return results;
        }
        results.add(content.substring(startTagStart, endTagEnd + 1));
        if (lowerContent.indexOf(start, endTagEnd + 1) > 0) {
            results.addAll(HtmlUtils.extractContent(content, start, end, endTagEnd));
        }
        return results;
    }

    static class ContentFinder {
        private int startTagStart;
        private int startTagEnd;
        private int endTagStart;
        private int endTagEnd;

        ContentFinder() {
            this.resetIndices();
        }

        private void resetIndices() {
            this.startTagStart = -1;
            this.startTagEnd = -1;
            this.endTagStart = -1;
            this.endTagEnd = -1;
        }

        public int getEndTagEnd() {
            return this.endTagEnd;
        }

        public int getEndTagStart() {
            return this.endTagStart;
        }

        public int getStartTagEnd() {
            return this.startTagEnd;
        }

        public int getStartTagStart() {
            return this.startTagStart;
        }

        public void doFind(String content, String start, String end, int startAtIndex) {
            this.resetIndices();
            String lowerContent = StringUtils.asciiLowerCase(content);
            if (lowerContent.indexOf(start, startAtIndex) > -1) {
                this.startTagStart = lowerContent.indexOf(start, startAtIndex);
                this.startTagEnd = lowerContent.indexOf(">", this.startTagStart);
            }
            if (lowerContent.indexOf(end, this.startTagEnd) > this.startTagEnd) {
                this.endTagStart = lowerContent.indexOf(end, this.startTagEnd);
                this.endTagEnd = lowerContent.indexOf(">", this.endTagStart);
            }
        }
    }
}

