/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;
import uk.ac.warwick.util.core.StringUtils;

public abstract class TextPatternTransformer
implements TextTransformer {
    private static final char CLOSING_ANGLE_BRACKET = '>';
    private static final char OPENING_ANGLE_BRACKET = '<';
    private static final char TERMINATING_SLASH = '/';

    protected abstract Pattern getPattern();

    protected abstract Callback getCallback();

    protected abstract boolean isGeneratesHead();

    public final MutableContent apply(MutableContent mc) {
        String text = mc.getContent();
        text = TextPatternTransformer.transform(text, this.getPattern(), this.getCallback(), mc, !this.isGeneratesHead());
        mc.setContent(text);
        return mc;
    }

    public static final String transform(String theContent, Pattern pattern, Callback callback, MutableContent mc, boolean ignoreHead) {
        return TextPatternTransformer.alternateTransform(theContent, pattern, callback, new Callback(){

            @Override
            public String transform(String input, MutableContent mc) {
                return input;
            }
        }, mc, ignoreHead);
    }

    public static final <T> List<T> collect(String content, Pattern pattern, Function<String, T> fn) {
        Matcher matcher = pattern.matcher(content);
        ArrayList transformed = Lists.newArrayList();
        int startIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            transformed.add(fn.apply((Object)content.substring(startIndex, endIndex)));
        }
        return transformed;
    }

    public static final String alternateTransform(String theContent, Pattern pattern, Callback innerCallback, Callback outerCallback, MutableContent mc, boolean ignoreHead) {
        Matcher matcher = pattern.matcher(theContent);
        StringBuilder sb = new StringBuilder();
        StringBuilder allHead = new StringBuilder();
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(TextPatternTransformer.transform(outerCallback, theContent.substring(lastMatch, startIndex), mc, allHead, ignoreHead));
            sb.append(TextPatternTransformer.transform(innerCallback, theContent.substring(startIndex, endIndex), mc, allHead, ignoreHead));
            lastMatch = endIndex;
        }
        sb.append(TextPatternTransformer.transform(outerCallback, theContent.substring(endIndex), mc, allHead, ignoreHead));
        String html = sb.toString();
        if (!ignoreHead && allHead.length() > 0) {
            String head = allHead.toString();
            html = !HTMLSTART.matcher(html).find() ? "<html><head>" + head + "</head><body>" + html + "</body></html>" : (!HEADEND.matcher(html).find() ? HTMLSTART.matcher(html).replaceFirst("$1<head>" + Matcher.quoteReplacement(head) + "</head>") : HEADEND.matcher(html).replaceFirst(Matcher.quoteReplacement(head) + "$1"));
        }
        return html;
    }

    private static String transform(Callback callback, String string, MutableContent mc, StringBuilder allHead, boolean ignoreHead) {
        String transformed = callback.transform(string, mc);
        if (ignoreHead) {
            return transformed;
        }
        String body = TextPatternTransformer.getTagAndContents(transformed, "body");
        if (body == null) {
            return transformed;
        }
        String head = TextPatternTransformer.getTagAndContents(transformed, "head");
        if (head != null) {
            allHead.append(head);
        }
        return body;
    }

    public static String getTagAndContents(String thehtml, String tagToFind) {
        int nextAngleBracket = thehtml.indexOf(60);
        if (nextAngleBracket != -1) {
            int startOfBody = -1;
            int endOfBody = -1;
            boolean foundBothStartAndEnd = false;
            while (nextAngleBracket != -1 && !foundBothStartAndEnd) {
                char maybeTerminatingSlash = thehtml.charAt(nextAngleBracket + 1);
                String tag = TextPatternTransformer.getPotentialTag(thehtml, nextAngleBracket, maybeTerminatingSlash, tagToFind);
                if (tagToFind.equalsIgnoreCase(tag)) {
                    int nextCloseBracket = thehtml.indexOf(62, nextAngleBracket + tag.length());
                    if (maybeTerminatingSlash != '/') {
                        startOfBody = nextCloseBracket + 1;
                    } else {
                        endOfBody = nextAngleBracket;
                    }
                }
                foundBothStartAndEnd = startOfBody > -1 && endOfBody > -1;
                nextAngleBracket = thehtml.indexOf(60, nextAngleBracket + 1);
            }
            return TextPatternTransformer.retrieveText(thehtml, startOfBody, endOfBody, foundBothStartAndEnd);
        }
        return null;
    }

    private static String getPotentialTag(String text, int nextAngleBracket, char maybeTerminatingSlash, String tag) {
        int start = 0;
        int end = 0;
        if (maybeTerminatingSlash == '/') {
            start = nextAngleBracket + 2;
            end = nextAngleBracket + tag.length() + 2;
        } else {
            start = nextAngleBracket + 1;
            end = nextAngleBracket + tag.length() + 1;
        }
        return StringUtils.safeSubstring(text, start, end);
    }

    private static String retrieveText(String text, int startOfBody, int endOfBody, boolean foundBothStartAndEnd) {
        String result = startOfBody > endOfBody && startOfBody != -1 && endOfBody != -1 ? null : (startOfBody == -1 && endOfBody == -1 ? null : (foundBothStartAndEnd ? text.substring(startOfBody, endOfBody) : (startOfBody > -1 ? text.substring(startOfBody) : (endOfBody > -1 ? text.substring(0, endOfBody) : text))));
        return result;
    }

    public static interface Callback {
        public String transform(String var1, MutableContent var2);
    }
}

