/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.Attribute;
import uk.ac.warwick.util.content.texttransformers.AttributeStringParser;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public abstract class AbstractMagicTagTransformer
implements TextTransformer {
    private final String[] tagNames;
    private final Pattern tagPattern;
    private boolean doQuickCheck = true;

    protected AbstractMagicTagTransformer(String[] theTagNames, Pattern theTagPattern) {
        this.tagNames = theTagNames;
        this.tagPattern = theTagPattern;
    }

    public boolean applies(MutableContent mc) {
        String html = mc.getContent();
        boolean found = false;
        for (String tagName : this.tagNames) {
            if (html.toLowerCase().indexOf(("[" + tagName).toLowerCase()) == -1) continue;
            found = true;
        }
        if (!found) {
            return false;
        }
        return this.getTagPattern().matcher(html).find();
    }

    public final MutableContent apply(MutableContent mc) {
        String transformed;
        if (this.doQuickCheck && !this.applies(mc)) {
            return mc;
        }
        String html = mc.getContent();
        Pattern noTextile = Pattern.compile("<notextile>(.*?)</notextile>", 34);
        Matcher matcher = noTextile.matcher(html);
        StringBuilder sb = new StringBuilder();
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        ArrayList heads = Lists.newArrayList();
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            transformed = TextPatternTransformer.transform(html.substring(lastMatch, startIndex), this.getTagPattern(), this.getCallback(), mc, !this.isTagGeneratesHead());
            sb.append(AbstractMagicTagTransformer.extractHeads(transformed, heads));
            sb.append(html.substring(startIndex, endIndex));
            lastMatch = endIndex;
        }
        transformed = TextPatternTransformer.transform(html.substring(endIndex), this.getTagPattern(), this.getCallback(), mc, !this.isTagGeneratesHead());
        sb.append(AbstractMagicTagTransformer.extractHeads(transformed, heads));
        if (heads.isEmpty()) {
            mc.setContent(sb.toString());
        } else {
            String output = sb.toString();
            for (String head : heads) {
                output = this.injectHead(output, head);
            }
            mc.setContent(output);
        }
        return mc;
    }

    public final <T> List<T> collect(MutableContent mc, Function<String, T> function) {
        if (!this.applies(mc)) {
            return Collections.emptyList();
        }
        ArrayList transformed = Lists.newArrayList();
        String html = mc.getContent();
        Pattern noTextile = Pattern.compile("<notextile>(.*?)</notextile>", 34);
        Matcher matcher = noTextile.matcher(html);
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            transformed.addAll(TextPatternTransformer.collect(html.substring(lastMatch, startIndex), this.getTagPattern(), function));
            lastMatch = endIndex;
        }
        transformed.addAll(TextPatternTransformer.collect(html.substring(endIndex), this.getTagPattern(), function));
        return transformed;
    }

    static String extractHeads(String html, List<String> heads) {
        if (html.indexOf("<head") == -1) {
            return html;
        }
        Matcher m = HEAD_MATCHER.matcher(html);
        StringBuilder sb = new StringBuilder();
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        while (m.find()) {
            startIndex = m.start();
            endIndex = m.end();
            sb.append(html.substring(lastMatch, startIndex).trim());
            heads.add(m.group(1));
            lastMatch = endIndex;
        }
        sb.append(html.substring(endIndex).trim());
        String transformed = sb.toString();
        String body = TextPatternTransformer.getTagAndContents(transformed, "body");
        if (body == null) {
            return transformed;
        }
        return body;
    }

    private String injectHead(String originalHtml, String head) {
        String html = originalHtml;
        html = !HTMLSTART.matcher(html).find() ? "<html><head>" + head + "</head><body>" + html + "</body></html>" : (!HEADEND.matcher(html).find() ? HTMLSTART.matcher(html).replaceFirst("$1<head>" + head.replace("$", "\\$") + "</head>") : HEADEND.matcher(html).replaceFirst(head.replace("$", "\\$") + "$1"));
        return html;
    }

    protected final Map<String, Object> extractParameters(String string) {
        if (string == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        AttributeStringParser parser = new AttributeStringParser(string);
        List<Attribute> attributes = parser.getAttributes();
        for (Attribute a : attributes) {
            String name = a.getName().toLowerCase();
            if (this.getAllowedParameters() == null) {
                result.put(name, a.getValue());
                continue;
            }
            for (String allowedParameter : this.getAllowedParameters()) {
                if (!name.equals(allowedParameter)) continue;
                result.put(name, a.getValue());
            }
        }
        return result;
    }

    public final Pattern getTagPattern() {
        return this.tagPattern;
    }

    protected abstract boolean isTagGeneratesHead();

    protected abstract String[] getAllowedParameters();

    protected abstract TextPatternTransformer.Callback getCallback();

    public final boolean isDoQuickCheck() {
        return this.doQuickCheck;
    }

    public final void setDoQuickCheck(boolean doQuickCheck) {
        this.doQuickCheck = doQuickCheck;
    }
}

