/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.textile2.jruby;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.textile2.jruby.TextileService;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public final class JRubyTextileTextTransformer
implements TextTransformer {
    private static JRubyTextileTextTransformer INSTANCE;
    private static final Logger LOGGER;
    private boolean hardBreaks;
    private final TextileService service;

    public static JRubyTextileTextTransformer getInstance() {
        return INSTANCE;
    }

    private JRubyTextileTextTransformer(TextileService service) {
        this.service = service;
    }

    private JRubyTextileTextTransformer() throws IOException {
        int n;
        Ruby runtime = Ruby.newInstance();
        InputStream redclothFileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("redcloth_jruby.rb");
        if (redclothFileInputStream == null) {
            throw new IllegalStateException("Could not find redcloth source");
        }
        StringBuffer outputBuffer = new StringBuffer();
        byte[] bytes = new byte[4096];
        while ((n = redclothFileInputStream.read(bytes)) != -1) {
            outputBuffer.append(new String(bytes, 0, n));
        }
        runtime.evalScriptlet(outputBuffer.toString());
        String expr = "RedClothTextileEngine.new";
        IRubyObject rawRubyObject = runtime.evalScriptlet(expr);
        this.service = (TextileService)JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)rawRubyObject, TextileService.class);
    }

    public MutableContent apply(MutableContent mc) {
        String text = mc.getContent();
        text = this.service.textileToHtml(text, this.hardBreaks);
        mc.setContent(text);
        return mc;
    }

    public boolean isHardBreaks() {
        return this.hardBreaks;
    }

    private void setHardBreaks(boolean hardBreaks) {
        this.hardBreaks = hardBreaks;
    }

    public JRubyTextileTextTransformer withHardBreaks(boolean hardBreaks) {
        JRubyTextileTextTransformer j = new JRubyTextileTextTransformer(this.service);
        j.setHardBreaks(hardBreaks);
        return j;
    }

    static {
        LOGGER = LoggerFactory.getLogger(JRubyTextileTextTransformer.class);
        try {
            INSTANCE = new JRubyTextileTextTransformer();
        }
        catch (IOException e) {
            INSTANCE = null;
            LOGGER.error("Could not instantiate JRuby server", (Throwable)e);
        }
    }
}

