/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.freemarker.spring;

import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public final class FreeMarkerCompilerEventListener
implements ApplicationListener,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FreeMarkerCompilerEventListener.class);
    private final File templateDir;
    private final Configuration configuration;
    private ApplicationContext applicationContext;
    private String freemarkerNoPrecompileProperty;

    public FreeMarkerCompilerEventListener(Configuration theConfiguration, Resource theResource) {
        this.configuration = theConfiguration;
        this.templateDir = this.verifyResource(theResource);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && ((ContextRefreshedEvent)event).getApplicationContext().equals(this.applicationContext)) {
            this.compile();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private File verifyResource(Resource resource) {
        File file;
        try {
            file = resource.getFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Resource " + resource + " must be a directory!", e);
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException("Resource " + resource + " must be a directory!");
        }
        return file;
    }

    private void compile() {
        String[] templateNames;
        if ("true".equals(this.freemarkerNoPrecompileProperty)) {
            return;
        }
        for (String name : templateNames = this.getTemplateNames()) {
            try {
                LOGGER.info("Precompiling freemarker template [" + name + "]");
                this.configuration.getTemplate(name);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get template for " + name, e);
            }
        }
    }

    private String[] getTemplateNames() {
        ArrayList<String> files = new ArrayList<String>();
        for (File file : this.templateDir.listFiles()) {
            this.findFreeMarkerTemplates(file, "", files);
        }
        return files.toArray(new String[0]);
    }

    private void findFreeMarkerTemplates(File root, String parentPath, List<String> filesFound) {
        if (root.isDirectory()) {
            String newParentPath = parentPath;
            if (StringUtils.hasLength((String)newParentPath)) {
                newParentPath = newParentPath + "/";
            }
            newParentPath = newParentPath + root.getName();
            for (File file : root.listFiles()) {
                this.findFreeMarkerTemplates(file, newParentPath, filesFound);
            }
        } else if (root.getName().toLowerCase().endsWith(".ftl")) {
            filesFound.add(parentPath + "/" + root.getName());
        }
    }

    public void setNoPrecompile(String noPrecompile) {
        this.freemarkerNoPrecompileProperty = noPrecompile;
    }
}

