/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.freemarker;

import com.google.common.collect.Maps;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import uk.ac.warwick.util.content.freemarker.DateTimeFreemarkerObjectWrapper;

public final class FreeMarkerRenderingUtils {
    private FreeMarkerRenderingUtils() {
    }

    public static StringWriter processTemplate(Configuration configuration, String templateName) {
        return FreeMarkerRenderingUtils.processTemplate(configuration, templateName, Maps.newHashMap());
    }

    public static StringWriter processTemplate(String templateName, Map<String, Object> model) {
        Configuration configuration = FreeMarkerRenderingUtils.generateConfig();
        return FreeMarkerRenderingUtils.processTemplate(configuration, templateName, model);
    }

    public static StringWriter processTemplate(Configuration configuration, String templateName, Map<String, Object> model) {
        if (configuration == null) {
            throw new IllegalStateException("Configuration cannot be null");
        }
        Template template = null;
        try {
            template = configuration.getTemplate(templateName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot locate template " + templateName, e);
        }
        StringWriter sw = FreeMarkerRenderingUtils.processTemplate(template, model);
        return sw;
    }

    public static StringWriter processTemplate(Template template, Map<String, Object> model) {
        StringWriter sw = new StringWriter();
        try {
            template.process(model, (Writer)sw);
        }
        catch (TemplateException e) {
            throw new IllegalStateException("Cannot process " + template.getName(), e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unknown IOException with " + template.getName(), e);
        }
        return sw;
    }

    private static Configuration generateConfig() {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_21);
        configuration.setObjectWrapper((ObjectWrapper)new DateTimeFreemarkerObjectWrapper());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setOutputEncoding("UTF-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(FreeMarkerRenderingUtils.class, "/freemarker");
        configuration.setTemplateLoader((TemplateLoader)templateLoader);
        return configuration;
    }
}

