/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.content.DefaultHtmlSerializer;
import uk.ac.warwick.util.content.HtmlParser;
import uk.ac.warwick.util.content.HtmlParsingException;
import uk.ac.warwick.util.core.StringUtils;

public class MutableContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableContent.class);
    private String content;
    private byte[] contentBytes;
    private Charset contentEncoding;
    private Document document;
    private int numChanges = 0;
    private final HtmlParser contentParser;
    private Map<String, Object> pipelinedData;

    public MutableContent(HtmlParser contentParser, String content) {
        this(contentParser, content, StringUtils.DEFAULT_CHARSET);
    }

    public MutableContent(HtmlParser contentParser, String content, Charset contentEncoding) {
        this.contentParser = contentParser;
        this.content = content;
        this.contentEncoding = contentEncoding;
    }

    public String getContent() {
        if (this.content == null) {
            if (this.document != null) {
                this.content = new DefaultHtmlSerializer().serialize(this.document);
            } else if (this.contentBytes != null) {
                Charset useEncoding = this.contentEncoding != null ? this.contentEncoding : Charsets.UTF_8;
                this.content = useEncoding.decode(ByteBuffer.wrap(this.contentBytes)).toString();
            }
        }
        return this.content;
    }

    public void setContent(String newContent) {
        if (this.content == null || !this.content.equals(newContent)) {
            this.content = newContent;
            this.document = null;
            this.contentBytes = null;
            this.incrementNumChanges();
        }
    }

    public InputStream getContentBytes() {
        return new ByteArrayInputStream(this.getRawContentBytes());
    }

    protected byte[] getRawContentBytes() {
        if (this.contentBytes == null) {
            if (this.content != null) {
                this.setContentBytesState(this.getBytes(this.content), this.contentEncoding);
            } else if (this.document != null) {
                this.setContentBytesState(this.getBytes(new DefaultHtmlSerializer().serialize(this.document)), this.contentEncoding);
            }
        }
        return this.contentBytes;
    }

    public byte[] getBytes(String s) {
        if (s == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        ByteBuffer bb = this.contentEncoding.encode(s);
        return ArrayUtils.subarray((byte[])bb.array(), (int)0, (int)bb.limit());
    }

    public void setContentBytes(byte[] newBytes, Charset newEncoding) {
        if (this.contentBytes == null || !Arrays.equals(this.contentBytes, newBytes)) {
            this.setContentBytesState(newBytes, newEncoding);
            this.document = null;
            this.content = null;
            this.incrementNumChanges();
        }
    }

    public final void setContentBytes(byte[] newBytes) {
        this.setContentBytes(newBytes, null);
    }

    protected void setContentBytesState(byte[] newBytes, Charset newEncoding) {
        this.contentBytes = newBytes;
        this.contentEncoding = newEncoding;
    }

    public void documentChanged() {
        if (this.document != null) {
            this.content = null;
            this.contentBytes = null;
            this.incrementNumChanges();
        }
    }

    public Document getDocument() {
        if (this.document != null) {
            return this.document;
        }
        try {
            this.document = this.contentParser.parseDOM(this.getContent());
        }
        catch (HtmlParsingException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        return this.document;
    }

    public int getNumChanges() {
        return this.numChanges;
    }

    protected void incrementNumChanges() {
        ++this.numChanges;
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    public void addPipelinedData(String key, Object value) {
        if (null == this.pipelinedData) {
            this.pipelinedData = Maps.newHashMap();
        }
        this.pipelinedData.put(key, value);
    }

    public Map<String, Object> getPipelinedData() {
        return null == this.pipelinedData ? ImmutableMap.of() : this.pipelinedData;
    }
}

