/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.concurrency;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import uk.ac.warwick.util.concurrency.CountingCompletionService;
import uk.ac.warwick.util.concurrency.TaskExecutionService;

public final class TaskExecutionCompletionService<T>
extends ExecutorCompletionService<T>
implements CountingCompletionService<T> {
    private int submittedTasks = 0;

    public TaskExecutionCompletionService(TaskExecutionService executor) {
        super(executor);
    }

    @Override
    public Future<T> submit(Callable<T> task) {
        ++this.submittedTasks;
        return super.submit(task);
    }

    @Override
    public Future<T> submit(Runnable task, T result) {
        ++this.submittedTasks;
        return super.submit(task, result);
    }

    @Override
    public Future<T> poll() {
        Future future = super.poll();
        if (future != null) {
            --this.submittedTasks;
        }
        return future;
    }

    @Override
    public Future<T> poll(long timeout, TimeUnit unit) throws InterruptedException {
        Future future = super.poll(timeout, unit);
        if (future != null) {
            --this.submittedTasks;
        }
        return future;
    }

    @Override
    public Future<T> take() throws InterruptedException {
        --this.submittedTasks;
        return super.take();
    }

    @Override
    public List<T> waitForCompletion(boolean throwOnException) throws InterruptedException, ExecutionException {
        ArrayList results = Lists.newArrayList();
        for (int i = this.submittedTasks; i > 0; --i) {
            try {
                results.add(this.take().get());
                continue;
            }
            catch (CancellationException | ExecutionException e) {
                if (!throwOnException) continue;
                throw e;
            }
        }
        return results;
    }
}

