/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections.google;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BasePredicate<T>
implements Predicate<T> {
    public static <T> BasePredicate<T> from(Predicate<T> predicate) {
        return predicate instanceof BasePredicate ? (BasePredicate<T>)predicate : new WrappedPredicate<T>(predicate);
    }

    public abstract boolean apply(T var1);

    public Iterable<T> filter(Iterable<T> unfiltered) {
        return Iterables.filter(unfiltered, (Predicate)this);
    }

    public T find(Iterable<T> iterable) {
        return (T)Iterables.find(iterable, (Predicate)this);
    }

    public boolean any(Iterable<T> iterable) {
        return Iterables.any(iterable, (Predicate)this);
    }

    public boolean all(Iterable<T> iterable) {
        return Iterables.all(iterable, (Predicate)this);
    }

    public Set<T> filter(Set<T> unfiltered) {
        return Sets.filter(unfiltered, (Predicate)this);
    }

    public List<T> filteredCopy(Iterable<T> unfiltered) {
        return Lists.newArrayList(this.filter(unfiltered));
    }

    public Collection<T> filter(Collection<T> unfiltered) {
        return Collections2.filter(unfiltered, (Predicate)this);
    }

    public <V> Map<T, V> filterKeys(Map<T, V> unfiltered) {
        return Maps.filterKeys(unfiltered, (Predicate)this);
    }

    public <K> Map<K, T> filterValues(Map<K, T> unfiltered) {
        return Maps.filterValues(unfiltered, (Predicate)this);
    }

    public static <T> BasePredicate<T> alwaysTrue() {
        return new WrappedPredicate(Predicates.alwaysTrue());
    }

    public static <T> BasePredicate<T> alwaysFalse() {
        return new WrappedPredicate(Predicates.alwaysFalse());
    }

    public static <T> BasePredicate<T> isNull() {
        return new WrappedPredicate(Predicates.isNull());
    }

    public static <T> BasePredicate<T> notNull() {
        return new WrappedPredicate(Predicates.notNull());
    }

    public static <T> BasePredicate<T> not(Predicate<T> predicate) {
        return new WrappedPredicate(Predicates.not(predicate));
    }

    public static <T> BasePredicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new WrappedPredicate(Predicates.and(components));
    }

    public static <T> BasePredicate<T> and(Predicate<? super T> ... components) {
        return new WrappedPredicate(Predicates.and(components));
    }

    public static <T> BasePredicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        return new WrappedPredicate(Predicates.and(first, second));
    }

    public static <T> BasePredicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new WrappedPredicate(Predicates.or(components));
    }

    public static <T> BasePredicate<T> or(Predicate<? super T> ... components) {
        return new WrappedPredicate(Predicates.or(components));
    }

    public static <T> BasePredicate<T> or(Predicate<? super T> first, Predicate<? super T> second) {
        return new WrappedPredicate(Predicates.or(first, second));
    }

    public static <T> BasePredicate<T> equalTo(T target) {
        return new WrappedPredicate(Predicates.equalTo(target));
    }

    public static BasePredicate<Object> instanceOf(Class<?> clazz) {
        return new WrappedPredicate<Object>(Predicates.instanceOf(clazz));
    }

    public static <T> BasePredicate<T> in(Collection<? extends T> target) {
        return new WrappedPredicate(Predicates.in(target));
    }

    public static <A, B> BasePredicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new WrappedPredicate(Predicates.compose(predicate, function));
    }

    private static final class WrappedPredicate<T>
    extends BasePredicate<T> {
        private final Predicate<T> predicate;

        public WrappedPredicate(Predicate<T> p) {
            this.predicate = p;
        }

        @Override
        public boolean apply(T object) {
            return this.predicate.apply(object);
        }
    }
}

