/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class LazyList<T>
implements List<T> {
    private final List<T> list;
    private final Factory<T> factory;

    LazyList(List<T> delegate, Factory<T> theFactory) {
        this.list = delegate;
        this.factory = theFactory;
    }

    private List<T> getList() {
        return this.list;
    }

    @Override
    public T get(int index) {
        int size = this.getList().size();
        if (index < size) {
            T object = this.getList().get(index);
            if (object == null) {
                object = this.factory.create();
                this.getList().set(index, object);
                return object;
            }
            return object;
        }
        for (int i = size; i < index; ++i) {
            this.getList().add(null);
        }
        T object = this.factory.create();
        this.getList().add(object);
        return object;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        List<T> sub = this.getList().subList(fromIndex, toIndex);
        return new LazyList<T>(sub, this.factory);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public boolean add(T e) {
        return this.list.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <L> L[] toArray(L[] a) {
        return this.list.toArray(a);
    }

    public static <T> LazyList<T> decorate(List<T> list, Factory<T> factory) {
        return new LazyList<T>(list, factory);
    }

    public static interface Factory<T> {
        public T create();
    }
}

