/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <X> SortedMap<String, Collection<X>> groupByProperty(Collection<X> collection, String property) {
        return CollectionUtils.groupByProperty(collection, property, null);
    }

    public static <X> SortedMap<String, Collection<X>> groupByProperty(Collection<X> collection, String property, Comparator<String> comparator) {
        TreeMap map = comparator != null ? new TreeMap(comparator) : new TreeMap();
        String propertyGetter = "get" + CollectionUtils.capitalise(property);
        for (X o : collection) {
            ArrayList<X> group;
            String value = CollectionUtils.callGetter(o, propertyGetter);
            if (value == null) {
                value = "";
            }
            if ((group = (ArrayList<X>)map.get(value)) == null) {
                group = new ArrayList<X>();
                map.put(value, group);
            }
            group.add(o);
        }
        return map;
    }

    public static <Y, X extends Y> Collection<X> filterByClass(Collection<Y> collection, Class<X> clazz) {
        return Lists.newArrayList((Iterable)Iterables.filter(collection, clazz));
    }

    public static <E> Set<E> toSet(Collection<E> collection) {
        return Sets.newHashSet(collection);
    }

    public static <E> Map<E, Integer> countOccurrences(Collection<E> collection) {
        HashMap<E, Integer> map = new HashMap<E, Integer>();
        for (E item : collection) {
            if (map.containsKey(item)) {
                map.put(item, (Integer)map.get(item) + 1);
                continue;
            }
            map.put(item, 1);
        }
        return map;
    }

    public static String[] joinArrays(String[] oneArray, String[] twoArray) {
        String[] result = new String[oneArray.length + twoArray.length];
        System.arraycopy(oneArray, 0, result, 0, oneArray.length);
        System.arraycopy(twoArray, 0, result, oneArray.length, twoArray.length);
        return result;
    }

    public static <T> List<T> splice(List<T> list, int num, int skip) {
        int toIndex;
        if (list.isEmpty()) {
            return list;
        }
        int fromIndex = skip;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > list.size() - 1) {
            fromIndex = list.size() - 1;
        }
        if ((toIndex = num + fromIndex) > list.size()) {
            toIndex = list.size();
        }
        if (fromIndex > toIndex) {
            toIndex = fromIndex;
        }
        return list.subList(fromIndex, toIndex);
    }

    public static <T> Iterable<T> iterable(Enumeration<T> enumeration) {
        return new IterableEnumeration<T>(enumeration);
    }

    private static String callGetter(Object bean, String getterMethod) {
        try {
            Class<?> clazz = bean.getClass();
            Method method = clazz.getMethod(getterMethod, new Class[0]);
            Object value = method.invoke(bean, new Object[0]);
            return value == null ? null : value.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to get value of bean property", e);
        }
    }

    private static String capitalise(String property) {
        char[] cs = property.toCharArray();
        cs[0] = Character.toUpperCase(cs[0]);
        return new String(cs);
    }

    private static class IterableEnumeration<T>
    implements Iterable<T>,
    Iterator<T> {
        private final Enumeration<T> enumeration;

        IterableEnumeration(Enumeration<T> e) {
            this.enumeration = e;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

