/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.cache.BasicCache;
import uk.ac.warwick.util.cache.CacheEntry;
import uk.ac.warwick.util.cache.CacheEntryFactoryWithDataInitialisation;
import uk.ac.warwick.util.cache.CacheExpiryStrategy;
import uk.ac.warwick.util.cache.CacheStatistics;
import uk.ac.warwick.util.cache.CacheStore;
import uk.ac.warwick.util.cache.CacheWithDataInitialisation;
import uk.ac.warwick.util.cache.Caches;
import uk.ac.warwick.util.cache.TTLCacheExpiryStrategy;

public class CaffeineCacheStore<K extends Serializable, V extends Serializable>
implements CacheStore<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaffeineCacheStore.class);
    private static final ConcurrentMap<String, Cache<?, ?>> caches = new ConcurrentHashMap();
    private final String cacheName;
    private final Cache<K, CacheEntry<K, V>> caffeineCache;

    CaffeineCacheStore(String name, Cache<K, CacheEntry<K, V>> caffeineCache) {
        this.cacheName = name;
        this.caffeineCache = caffeineCache;
    }

    @Override
    public CacheEntry<K, V> get(K key) {
        return (CacheEntry)this.caffeineCache.getIfPresent(key);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAll(List<K> keys) {
        Map results = keys.stream().collect(HashMap::new, (m, k) -> {
            CacheEntry cfr_ignored_0 = m.put(k, null);
        }, HashMap::putAll);
        results.putAll(this.caffeineCache.getAllPresent(keys));
        return results;
    }

    @Override
    public void put(CacheEntry<K, V> entry, Duration ttl) {
        this.caffeineCache.put(entry.getKey(), entry);
    }

    @Override
    public boolean remove(K key) {
        this.caffeineCache.invalidate(key);
        return true;
    }

    @Override
    public CacheStatistics getStatistics() {
        return new CacheStatistics(this.caffeineCache.estimatedSize());
    }

    @Override
    public void setMaxSize(int max) {
        LOGGER.debug("setMaxSize() called on CaffeineCacheStore which does not support it");
    }

    @Override
    public boolean clear() {
        this.caffeineCache.invalidateAll();
        return true;
    }

    @Override
    public boolean contains(K key) {
        return this.caffeineCache.asMap().containsKey(key);
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public void shutdown() {
        this.clear();
    }

    @VisibleForTesting
    public Cache<K, CacheEntry<K, V>> getCaffeineCache() {
        return this.caffeineCache;
    }

    public static class Builder<K extends Serializable, V extends Serializable, T>
    implements Caches.Builder<K, V, T> {
        private final String name;
        private CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory;
        private CacheExpiryStrategy<K, V> expiryStrategy = TTLCacheExpiryStrategy.eternal();
        private long maximumSize = 0L;
        private boolean asynchronousUpdateEnabled;
        private boolean asynchronousOnly;

        public Builder(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory) {
            this.name = name;
            this.entryFactory = entryFactory;
        }

        private Builder(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory, CacheExpiryStrategy<K, V> expiryStrategy, long maximumSize, boolean asynchronousUpdateEnabled, boolean asynchronousOnly) {
            this(name, entryFactory);
            this.expiryStrategy = expiryStrategy;
            this.maximumSize = maximumSize;
            this.asynchronousUpdateEnabled = asynchronousUpdateEnabled;
            this.asynchronousOnly = asynchronousOnly;
        }

        @Override
        public <U> Builder<K, V, U> dataInitialisingEntryFactory(CacheEntryFactoryWithDataInitialisation<K, V, U> entryFactory) {
            return new Builder<K, V, U>(this.name, entryFactory, this.expiryStrategy, this.maximumSize, this.asynchronousUpdateEnabled, this.asynchronousOnly);
        }

        @Override
        public Builder<K, V, T> expireAfterWrite(Duration duration) {
            this.expiryStrategy = TTLCacheExpiryStrategy.forTTL(duration);
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> expiryStategy(CacheExpiryStrategy<K, V> expiryStrategy) {
            this.expiryStrategy = expiryStrategy;
            return this;
        }

        @Override
        public Builder<K, V, T> maximumSize(long size) {
            this.maximumSize = size;
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> asynchronous() {
            this.asynchronousUpdateEnabled = true;
            return this;
        }

        @Override
        public Caches.Builder<K, V, T> asynchronousOnly() {
            this.asynchronousUpdateEnabled = true;
            this.asynchronousOnly = true;
            return this;
        }

        @Override
        public Builder<K, V, T> properties(Properties properties) {
            LOGGER.debug("Properties can only be set with Memcached cache stores - ignoring");
            return this;
        }

        @Override
        public CaffeineCacheStore<K, V> buildStore() {
            return new CaffeineCacheStore(this.name, caches.computeIfAbsent(this.name, n -> {
                Caffeine builder = Caffeine.newBuilder();
                if (this.maximumSize <= 0L) {
                    throw new IllegalStateException("Unbounded cache creation is not permitted. Please specify a maximum size > 0.");
                }
                builder.maximumSize(this.maximumSize);
                return builder.build();
            }));
        }

        @Override
        public CacheWithDataInitialisation<K, V, T> build() {
            return new BasicCache<K, V, T>(this.buildStore(), this.entryFactory, this.expiryStrategy, this.asynchronousUpdateEnabled, this.asynchronousOnly);
        }
    }
}

