/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.cache;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.cache.Cache;
import uk.ac.warwick.util.cache.CacheEntryFactory;
import uk.ac.warwick.util.cache.CacheEntryFactoryWithDataInitialisation;
import uk.ac.warwick.util.cache.CacheEntryUpdateException;
import uk.ac.warwick.util.cache.CacheExpiryStrategy;
import uk.ac.warwick.util.cache.CacheStore;
import uk.ac.warwick.util.cache.CacheWithDataInitialisation;
import uk.ac.warwick.util.cache.HashMapCacheStore;
import uk.ac.warwick.util.cache.caffeine.CaffeineCacheStore;
import uk.ac.warwick.util.cache.memcached.MemcachedCacheStore;

public final class Caches {
    private static final Logger LOGGER = LoggerFactory.getLogger(Caches.class);
    private static boolean caffeineChecked;
    private static boolean caffeineAvailable;
    private static boolean memcachedChecked;
    private static boolean memcachedAvailable;

    private Caches() {
    }

    public static <K extends Serializable, V extends Serializable> Builder<K, V, Object> builder(String name) {
        return Caches.builder(name, CacheStrategy.CaffeineIfAvailable);
    }

    public static <K extends Serializable, V extends Serializable> Builder<K, V, Object> builder(String name, CacheStrategy strategy) {
        return Caches.builderWithDataInitialisation(name, null, strategy);
    }

    public static <K extends Serializable, V extends Serializable> Builder<K, V, Object> builder(String name, CacheEntryFactory<K, V> entryFactory) {
        return Caches.builder(name, entryFactory, CacheStrategy.CaffeineIfAvailable);
    }

    public static <K extends Serializable, V extends Serializable> Builder<K, V, Object> builder(String name, CacheEntryFactory<K, V> entryFactory, CacheStrategy strategy) {
        return Caches.builderWithDataInitialisation(name, Caches.wrapFactoryWithoutDataInitialisation(entryFactory), strategy);
    }

    public static <K extends Serializable, V extends Serializable, T> Builder<K, V, T> builderWithDataInitialisation(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory) {
        return Caches.builderWithDataInitialisation(name, entryFactory, CacheStrategy.CaffeineIfAvailable);
    }

    public static <K extends Serializable, V extends Serializable, T> Builder<K, V, T> builderWithDataInitialisation(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> entryFactory, CacheStrategy cacheStrategy) {
        switch (cacheStrategy) {
            case EhCacheRequired: {
                throw new UnsupportedOperationException("CacheStrategy is EhCacheRequired but EhCache no longer supported.");
            }
            case CaffeineRequired: {
                if (Caches.isCaffeineAvailable()) {
                    return new CaffeineCacheStore.Builder<K, V, T>(name, entryFactory);
                }
                throw new IllegalStateException("Caffeine unavailable for " + name);
            }
            case EhCacheIfAvailable: {
                LOGGER.info("CacheStrategy EhCacheIfAvailable requested but no longer supported; using CaffeineIfAvailable");
            }
            case CaffeineIfAvailable: {
                if (Caches.isCaffeineAvailable()) {
                    LOGGER.info("Caffeine detected - using CaffeineCacheStore for " + name + ".");
                    return new CaffeineCacheStore.Builder<K, V, T>(name, entryFactory);
                }
                LOGGER.info("Caffeine not found - using built in cache store for " + name + ".");
                return new HashMapCacheStore.Builder<K, V, T>(name, entryFactory);
            }
            case MemcachedRequired: {
                if (Caches.isMemcachedAvailable()) {
                    return new MemcachedCacheStore.Builder<K, V, T>(name, entryFactory);
                }
                throw new IllegalStateException("memcached unavailable for " + name);
            }
            case MemcachedIfAvailable: {
                if (Caches.isMemcachedAvailable()) {
                    return new MemcachedCacheStore.Builder<K, V, T>(name, entryFactory);
                }
                LOGGER.info("memcached not found - using built in cache store for " + name + ".");
                return new HashMapCacheStore.Builder<K, V, T>(name, entryFactory);
            }
            case InMemoryOnly: {
                return new HashMapCacheStore.Builder<K, V, T>(name, entryFactory);
            }
        }
        throw new IllegalArgumentException("Unexpected cache strategy: " + (Object)((Object)cacheStrategy));
    }

    public static <K extends Serializable, V extends Serializable> CacheEntryFactoryWithDataInitialisation<K, V, Object> wrapFactoryWithoutDataInitialisation(final CacheEntryFactory<K, V> factory) {
        if (factory == null) {
            return null;
        }
        return new CacheEntryFactoryWithDataInitialisation<K, V, Object>(){

            @Override
            public V create(K key, Object data) throws CacheEntryUpdateException {
                return factory.create(key);
            }

            @Override
            public Map<K, V> create(List<K> keys) throws CacheEntryUpdateException {
                return factory.create(keys);
            }

            @Override
            public boolean isSupportsMultiLookups() {
                return factory.isSupportsMultiLookups();
            }

            @Override
            public boolean shouldBeCached(V val) {
                return factory.shouldBeCached(val);
            }
        };
    }

    @Deprecated
    public static <K extends Serializable, V extends Serializable> Cache<K, V> newCache(String name, CacheEntryFactory<K, V> factory, long timeout) {
        return Caches.newCache(name, Caches.wrapFactoryWithoutDataInitialisation(factory), timeout, CacheStrategy.EhCacheIfAvailable);
    }

    @Deprecated
    public static <K extends Serializable, V extends Serializable> Cache<K, V> newCache(String name, CacheEntryFactory<K, V> factory, long timeout, CacheStrategy cacheStrategy) {
        return Caches.builder(name, factory, cacheStrategy).expireAfterWrite(Duration.ofSeconds(timeout)).build();
    }

    @Deprecated
    public static <K extends Serializable, V extends Serializable> Cache<K, V> newCache(String name, CacheEntryFactory<K, V> factory, long timeout, CacheStrategy cacheStrategy, Properties properties) {
        return Caches.builder(name, factory, cacheStrategy).expireAfterWrite(Duration.ofSeconds(timeout)).properties(properties).build();
    }

    @Deprecated
    public static <K extends Serializable, V extends Serializable, T> CacheWithDataInitialisation<K, V, T> newDataInitialisatingCache(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> factory, long timeout) {
        return Caches.newDataInitialisatingCache(name, factory, timeout, CacheStrategy.EhCacheIfAvailable);
    }

    @Deprecated
    public static <K extends Serializable, V extends Serializable, T> CacheWithDataInitialisation<K, V, T> newDataInitialisatingCache(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> factory, long timeout, CacheStrategy cacheStrategy) {
        return Caches.builderWithDataInitialisation(name, factory, cacheStrategy).expireAfterWrite(Duration.ofSeconds(timeout)).build();
    }

    @Deprecated
    public static <K extends Serializable, V extends Serializable, T> CacheWithDataInitialisation<K, V, T> newDataInitialisatingCache(String name, CacheEntryFactoryWithDataInitialisation<K, V, T> factory, long timeout, CacheStrategy cacheStrategy, Properties properties) {
        return Caches.builderWithDataInitialisation(name, factory, cacheStrategy).expireAfterWrite(Duration.ofSeconds(timeout)).properties(properties).build();
    }

    public static boolean isCaffeineAvailable() {
        if (!caffeineChecked) {
            try {
                Class.forName("com.github.benmanes.caffeine.cache.Caffeine");
                caffeineAvailable = true;
            }
            catch (ClassNotFoundException e) {
                caffeineAvailable = false;
            }
            caffeineChecked = true;
        }
        return caffeineAvailable;
    }

    public static void resetCaffeineCheck() {
        caffeineChecked = false;
    }

    public static boolean isMemcachedAvailable() {
        if (!memcachedChecked) {
            try {
                Class.forName("net.spy.memcached.MemcachedClient");
                memcachedAvailable = true;
            }
            catch (ClassNotFoundException e) {
                memcachedAvailable = false;
            }
            memcachedChecked = true;
        }
        return memcachedAvailable;
    }

    public static void resetMemcachedCheck() {
        memcachedChecked = false;
    }

    public static interface Builder<K extends Serializable, V extends Serializable, T> {
        public <U> Builder<K, V, U> dataInitialisingEntryFactory(CacheEntryFactoryWithDataInitialisation<K, V, U> var1);

        default public Builder<K, V, Object> entryFactory(CacheEntryFactory<K, V> entryFactory) {
            return this.dataInitialisingEntryFactory(Caches.wrapFactoryWithoutDataInitialisation(entryFactory));
        }

        public Builder<K, V, T> expireAfterWrite(Duration var1);

        public Builder<K, V, T> expiryStategy(CacheExpiryStrategy<K, V> var1);

        public Builder<K, V, T> maximumSize(long var1);

        public Builder<K, V, T> asynchronous();

        public Builder<K, V, T> asynchronousOnly();

        public Builder<K, V, T> properties(Properties var1);

        public CacheStore<K, V> buildStore();

        public CacheWithDataInitialisation<K, V, T> build();
    }

    public static enum CacheStrategy {
        EhCacheIfAvailable,
        EhCacheRequired,
        CaffeineIfAvailable,
        CaffeineRequired,
        MemcachedIfAvailable,
        MemcachedRequired,
        InMemoryOnly;

    }
}

