/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.atom.spring;

import com.google.common.collect.ImmutableSet;
import com.rometools.rome.feed.module.Module;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.jdom2.Namespace;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import uk.ac.warwick.util.collections.LazyList;
import uk.ac.warwick.util.core.StringUtils;

public interface SitebuilderModule
extends Module {
    public static final LazyList.Factory<PropertyEditor> INTEGER_PROPERTY_EDITOR_FACTORY = new LazyList.Factory<PropertyEditor>(){

        @Override
        public PropertyEditor create() {
            return new PropertyEditorSupport(){

                @Override
                public void setAsText(String text) throws IllegalArgumentException {
                    this.setValue(Integer.valueOf(text));
                }

                @Override
                public String getJavaInitializationString() {
                    return "" + this.getValue();
                }
            };
        }
    };
    public static final LazyList.Factory<CustomBooleanEditor> BOOLEAN_PROPERTY_EDITOR_FACTORY = new LazyList.Factory<CustomBooleanEditor>(){

        @Override
        public CustomBooleanEditor create() {
            return new CustomBooleanEditor(false);
        }
    };
    public static final LazyList.Factory<PropertyEditor> STRING_PROPERTY_EDITOR_FACTORY = new LazyList.Factory<PropertyEditor>(){

        @Override
        public PropertyEditor create() {
            return new PropertyEditorSupport(){

                @Override
                public void setAsText(String text) throws IllegalArgumentException {
                    String value = StringUtils.hasText(text) ? text.trim() : "";
                    this.setValue(value);
                }

                @Override
                public String getAsText() {
                    return StringUtils.nullGuard(this.getValue() == null ? "" : this.getValue().toString());
                }
            };
        }
    };
    public static final String MODULE_URI = "http://go.warwick.ac.uk/elab-schemas/atom";
    public static final Namespace NAMESPACE = Namespace.getNamespace((String)"sitebuilder", (String)"http://go.warwick.ac.uk/elab-schemas/atom");
    public static final Namespace ATOM_NAMESPACE = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");
    public static final Namespace ATOMPUB_NAMESPACE = Namespace.getNamespace((String)"http://purl.org/atom/app#");

    public String getPageName();

    public void setPageName(String var1);

    public Boolean getAllowSearchEngines();

    public void setAllowSearchEngines(Boolean var1);

    public Boolean getShowInLocalNavigation();

    public void setShowInLocalNavigation(Boolean var1);

    public Boolean getDeleted();

    public void setDeleted(Boolean var1);

    public Boolean getSpanRhs();

    public void setSpanRhs(Boolean var1);

    public String getHead();

    public void setHead(String var1);

    public String getLastUpdateComment();

    public void setLastUpdateComment(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public String getKeywords();

    public void setKeywords(String var1);

    public Boolean getIncludeLegacyJavascript();

    public void setIncludeLegacyJavascript(Boolean var1);

    public Integer getPageOrder();

    public void setPageOrder(Integer var1);

    public String getLinkTitle();

    public void setLinkTitle(String var1);

    public Boolean getCommentable();

    public void setCommentable(Boolean var1);

    public Boolean getCommentVisibleToCommentersOnly();

    public void setCommentVisibleToCommentersOnly(Boolean var1);

    public String getTitle();

    public void setTitle(String var1);

    public String getShortTitle();

    public void setShortTitle(String var1);

    public String getLayout();

    public void setLayout(String var1);

    public static enum Property {
        pageName("page-name", PropertyFlag.ReadOnly),
        head("head", PropertyFlag.ReadOnly, PropertyFlag.HtmlSpecific),
        allowSearchEngines("searchable", BOOLEAN_PROPERTY_EDITOR_FACTORY, new PropertyFlag[0]),
        showInLocalNavigation("visible", BOOLEAN_PROPERTY_EDITOR_FACTORY, new PropertyFlag[0]),
        deleted("deleted", BOOLEAN_PROPERTY_EDITOR_FACTORY, new PropertyFlag[0]),
        description("description", new PropertyFlag[0]),
        keywords("keywords", new PropertyFlag[0]),
        pageOrder("page-order", INTEGER_PROPERTY_EDITOR_FACTORY, new PropertyFlag[0]),
        linkTitle("link-caption", new PropertyFlag[0]),
        commentable("commentable", BOOLEAN_PROPERTY_EDITOR_FACTORY, new PropertyFlag[0]),
        commentVisibleToCommentersOnly("comments-visible-to-commenters-only", BOOLEAN_PROPERTY_EDITOR_FACTORY, new PropertyFlag[0]),
        lastUpdateComment("edit-comment", PropertyFlag.EditSpecific, PropertyFlag.HtmlSpecific),
        spanRhs("span-rhs", BOOLEAN_PROPERTY_EDITOR_FACTORY, PropertyFlag.HtmlSpecific),
        includeLegacyJavascript("include-legacy-js", BOOLEAN_PROPERTY_EDITOR_FACTORY, PropertyFlag.HtmlSpecific),
        title("page-heading", PropertyFlag.HtmlSpecific),
        shortTitle("title-bar-caption", PropertyFlag.HtmlSpecific),
        layout("layout", PropertyFlag.HtmlSpecific);

        private final String element;
        private final LazyList.Factory<? extends PropertyEditor> factory;
        private final ImmutableSet<PropertyFlag> flags;

        private Property(String e, PropertyFlag ... theFlags) {
            this(e, STRING_PROPERTY_EDITOR_FACTORY, theFlags);
        }

        private Property(String e, LazyList.Factory<? extends PropertyEditor> editor, PropertyFlag ... theFlags) {
            this.element = e;
            this.factory = editor;
            this.flags = ImmutableSet.copyOf((Object[])theFlags);
        }

        public String getElement() {
            return this.element;
        }

        public PropertyEditor newPropertyEditor() {
            return this.factory.create();
        }

        public boolean isEditSpecific() {
            return this.flags.contains((Object)PropertyFlag.EditSpecific);
        }

        public boolean isHtmlSpecific() {
            return this.flags.contains((Object)PropertyFlag.HtmlSpecific);
        }

        public boolean isReadOnly() {
            return this.flags.contains((Object)PropertyFlag.ReadOnly);
        }
    }

    public static enum PropertyFlag {
        ReadOnly,
        EditSpecific,
        HtmlSpecific;

    }
}

