/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.workingdays;

import java.io.IOException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Set;
import uk.ac.warwick.util.workingdays.WorkingDaysHelperImpl;
import uk.ac.warwick.util.workingdays.WorkingTimeHelper;

public class WorkingTimeHelperImpl
implements WorkingTimeHelper {
    private static final LocalTime DEFAULT_WORKING_TIME_START = LocalTime.of(9, 0);
    private static final LocalTime DEFAULT_WORKING_TIME_END = LocalTime.of(17, 0);
    private final Set<LocalDate> holidayDates;
    private final LocalTime workingTimeStart;
    private final LocalTime workingTimeEnd;

    public WorkingTimeHelperImpl() throws IOException {
        this.holidayDates = new WorkingDaysHelperImpl().getHolidayDates();
        this.workingTimeStart = DEFAULT_WORKING_TIME_START;
        this.workingTimeEnd = DEFAULT_WORKING_TIME_END;
    }

    public WorkingTimeHelperImpl(Set<LocalDate> holidayDates, LocalTime workingTimeStart, LocalTime workingTimeEnd) {
        this.holidayDates = holidayDates;
        this.workingTimeStart = workingTimeStart;
        this.workingTimeEnd = workingTimeEnd;
    }

    @Override
    public Duration getWorkingTimeBetween(OffsetDateTime start, OffsetDateTime end) {
        if (start.isEqual(end)) {
            return Duration.ZERO;
        }
        if (start.isAfter(end)) {
            OffsetDateTime temp = start;
            start = end;
            end = temp;
        }
        Duration accumulator = Duration.ZERO;
        boolean done = false;
        while (!done) {
            OffsetDateTime nextStart = this.getNextStartThreshold(start);
            if (nextStart.isAfter(end)) {
                done = true;
                continue;
            }
            OffsetDateTime nextEnd = this.getNextEndThreshold(nextStart);
            if (end.isBefore(nextEnd)) {
                accumulator = accumulator.plus(Duration.between(nextStart, end));
                done = true;
                continue;
            }
            accumulator = accumulator.plus(Duration.between(nextStart, nextEnd));
            start = nextEnd;
        }
        return accumulator;
    }

    private OffsetDateTime getNextStartThreshold(OffsetDateTime dateTime) {
        OffsetDateTime threshold = dateTime;
        if (this.isWorkingDate(threshold) && this.isWorkingTime(threshold)) {
            return threshold;
        }
        if (!threshold.toLocalTime().isBefore(this.workingTimeEnd)) {
            threshold = threshold.plusDays(1L);
        }
        boolean workingDate = this.isWorkingDate(threshold);
        while (!workingDate) {
            threshold = threshold.plusDays(1L);
            workingDate = this.isWorkingDate(threshold);
        }
        threshold = OffsetDateTime.of(threshold.toLocalDate(), this.workingTimeStart, threshold.getOffset());
        return threshold;
    }

    private OffsetDateTime getNextEndThreshold(OffsetDateTime dateTime) {
        OffsetDateTime threshold = dateTime;
        if (!this.isWorkingDate(threshold) || !this.isWorkingTime(threshold)) {
            return threshold;
        }
        threshold = OffsetDateTime.of(threshold.toLocalDate(), this.workingTimeEnd, threshold.getOffset());
        return threshold;
    }

    private boolean isWorkingDate(OffsetDateTime dateTime) {
        return dateTime.getDayOfWeek().compareTo(DayOfWeek.FRIDAY) <= 0 && !this.holidayDates.contains(dateTime.toLocalDate());
    }

    private boolean isWorkingTime(OffsetDateTime dateTime) {
        return !dateTime.toLocalTime().isBefore(this.workingTimeStart) && dateTime.toLocalTime().isBefore(this.workingTimeEnd);
    }
}

