/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.useragent;

import java.util.Map;
import ua_parser.Client;
import ua_parser.Parser;
import ua_parser.UserAgent;
import uk.ac.warwick.util.web.useragent.Targets;
import uk.ac.warwick.util.web.useragent.Version;

public class UserAgentParser {
    private final Parser parser = new Parser(this.getClass().getResourceAsStream("/uap-core-regexes.yaml"));
    public static final UserAgentParser INSTANCE = new UserAgentParser();

    public boolean matchTargets(String uaHeader, Targets targets) {
        Client result = this.parser.parse(uaHeader);
        for (Map.Entry<String, Version> entry : targets.getTargetVersions().entrySet()) {
            String target = entry.getKey();
            Version version = entry.getValue();
            switch (target) {
                case "chrome": {
                    if (!result.userAgent.family.contains("Chrome") || !this.versionGte(result.userAgent, version)) break;
                    return true;
                }
                case "firefox": {
                    if (!result.userAgent.family.contains("Firefox") || !this.versionGte(result.userAgent, version)) break;
                    return true;
                }
                case "safari": {
                    if (!result.userAgent.family.contains("Safari") || !this.versionGte(result.userAgent, version)) break;
                    return true;
                }
                case "edge": {
                    if (!result.userAgent.family.contains("Edge") || !this.versionGte(result.userAgent, version)) break;
                    return true;
                }
                case "ie": {
                    if (!result.userAgent.family.contains("IE") || !this.versionGte(result.userAgent, version)) break;
                    return true;
                }
                case "samsung": {
                    if (!result.userAgent.family.contains("Samsung") || !this.versionGte(result.userAgent, version)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSamesiteNoneCompatible(String uaHeader) {
        Client client = this.parser.parse(uaHeader);
        return !this.failsToStrict(client) && !this.failsWithDrop(client);
    }

    private boolean failsWithDrop(Client client) {
        try {
            int major = Integer.parseInt(client.userAgent.major);
            switch (client.userAgent.family) {
                case "Chrome": 
                case "Chromium": {
                    if (major >= 51 && major < 67) {
                        return true;
                    }
                }
                case "UCBrowser": {
                    int minor = Integer.parseInt(client.userAgent.minor);
                    int patch = Integer.parseInt(client.userAgent.patch);
                    if (major >= 12 || minor >= 13 || patch >= 2) break;
                    return true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private boolean failsToStrict(Client client) {
        switch (client.os.family) {
            case "iOS": {
                if ("12".equals(client.os.major)) {
                    return true;
                }
            }
            case "Mac OS X": {
                if (!"10".equals(client.os.major) || !"14".equals(client.os.minor) || !"Safari".equals(client.userAgent.family) && !"Apple Mail".equals(client.userAgent.family)) break;
                return true;
            }
        }
        return false;
    }

    private boolean versionGte(UserAgent ua, Version version) {
        try {
            int uaMajor = Integer.parseInt(ua.major);
            boolean gtMajor = uaMajor > version.major;
            boolean eqMajor = uaMajor >= version.major;
            return gtMajor || eqMajor && Integer.parseInt(ua.minor) >= version.minor;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

