/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.web.tags;

import java.io.IOException;
import java.util.Calendar;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public final class CopyrightTag
extends TagSupport {
    private static final long serialVersionUID = 8819001538449884405L;
    private static final SymTab[] ROMAN_SYMBOLS = new SymTab[]{new SymTab('M', 1000L), new SymTab('D', 500L), new SymTab('C', 100L), new SymTab('L', 50L), new SymTab('X', 10L), new SymTab('V', 5L), new SymTab('I', 1L)};

    public int doStartTag() throws JspException {
        String copyrightDate = this.getRomanNumerals();
        try {
            this.pageContext.getOut().print(copyrightDate);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    private String getRomanNumerals() {
        Calendar rightNow = Calendar.getInstance();
        int year = rightNow.get(1);
        return CopyrightTag.toRoman(year);
    }

    private static String toRoman(long input) {
        long n = input;
        String s = "";
        while (n > 0L) {
            for (int i = 0; i < ROMAN_SYMBOLS.length; ++i) {
                if (ROMAN_SYMBOLS[i].getValue() > n) continue;
                int shift = i + i % 2;
                if (i > 0 && shift < ROMAN_SYMBOLS.length && ROMAN_SYMBOLS[i - 1].getValue() - ROMAN_SYMBOLS[shift].getValue() <= n) {
                    s = s + ROMAN_SYMBOLS[shift].getSymbol() + ROMAN_SYMBOLS[i - 1].getSymbol();
                    n = n - ROMAN_SYMBOLS[i - 1].getValue() + ROMAN_SYMBOLS[shift].getValue();
                    i = -1;
                    continue;
                }
                s = s + ROMAN_SYMBOLS[i].getSymbol();
                n -= ROMAN_SYMBOLS[i].getValue();
                i = -1;
            }
        }
        return s;
    }

    public static class SymTab {
        private char symbol;
        private long value;

        public SymTab(char s, long v) {
            this.symbol = s;
            this.value = v;
        }

        public final char getSymbol() {
            return this.symbol;
        }

        public final long getValue() {
            return this.value;
        }
    }
}

