/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates.legacy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.threeten.extra.LocalDateRange;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.termdates.legacy.Term;
import uk.ac.warwick.util.termdates.legacy.TermFactory;
import uk.ac.warwick.util.termdates.legacy.TermImpl;
import uk.ac.warwick.util.termdates.legacy.TermNotFoundException;

@Deprecated
public final class TermFactoryImpl
implements TermFactory {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("ddMMyy");
    private LinkedList<Term> termDates;

    public TermFactoryImpl() throws IOException {
        String source = StringUtils.copyToString(new InputStreamReader(this.getClass().getResourceAsStream("/uk/ac/warwick/util/termdates/termdates.txt")));
        this.termDates = new LinkedList();
        StringTokenizer st = new StringTokenizer(source, "\n");
        while (st.hasMoreTokens()) {
            Term.TermType type;
            String line = st.nextToken().trim();
            String[] data = line.split(";");
            String startDateString = data[0];
            String endDateString = data[1];
            String termTypeString = data[2];
            LocalDate startDate = LocalDate.parse(startDateString, DATE_FORMATTER).with(DayOfWeek.MONDAY);
            LocalDate endDate = LocalDate.parse(endDateString, DATE_FORMATTER).with(DayOfWeek.SUNDAY);
            switch (termTypeString) {
                case "a": {
                    type = Term.TermType.autumn;
                    break;
                }
                case "sp": {
                    type = Term.TermType.spring;
                    break;
                }
                case "su": {
                    type = Term.TermType.summer;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid term string");
                }
            }
            this.termDates.add(new TermImpl(this, startDate, endDate, type));
        }
    }

    @Override
    public Term getTermFromDate(Temporal temporal) throws TermNotFoundException {
        LocalDate date = LocalDate.from(temporal);
        for (Term term : this.termDates) {
            if (!date.isEqual(term.getEndDate()) && !date.isBefore(term.getEndDate())) continue;
            return term;
        }
        throw new TermNotFoundException("Could not find a term date for date: " + date.toString());
    }

    @Override
    public Term getPreviousTerm(Term term) throws TermNotFoundException {
        LinkedList reversedTermDates = (LinkedList)this.termDates.clone();
        Collections.reverse(reversedTermDates);
        for (Term thisTerm : reversedTermDates) {
            if (!thisTerm.getStartDate().isBefore(term.getStartDate())) continue;
            return thisTerm;
        }
        throw new TermNotFoundException("Could not find a term before date: " + term.getStartDate().toString());
    }

    @Override
    public Term getNextTerm(Term term) throws TermNotFoundException {
        return this.getTermFromDate(term.getEndDate().plusDays(1L));
    }

    @Override
    public LocalDateRange getAcademicWeek(Temporal date, int weekNumber) throws TermNotFoundException {
        List<Pair<Integer, LocalDateRange>> weeks = this.getAcademicWeeksForYear(date);
        for (Pair<Integer, LocalDateRange> week : weeks) {
            if (week.getLeft() != weekNumber) continue;
            return week.getRight();
        }
        throw new TermNotFoundException("Couldn't find interval for academic week");
    }

    @Override
    public List<Pair<Integer, LocalDateRange>> getAcademicWeeksForYear(Temporal date) throws TermNotFoundException {
        ArrayList weeks = Lists.newArrayList();
        Term autumnTerm = this.getTermFromDate(date);
        while (autumnTerm.getTermType() != Term.TermType.autumn) {
            autumnTerm = this.getPreviousTerm(autumnTerm);
        }
        Term nextYearAutumnTerm = autumnTerm;
        while ((nextYearAutumnTerm = this.getNextTerm(nextYearAutumnTerm)).getTermType() != Term.TermType.autumn) {
        }
        LocalDate dt = autumnTerm.getStartDate().with(DayOfWeek.MONDAY);
        int weekNumber = autumnTerm.getAcademicWeekNumber(dt);
        while (weekNumber > 0 && dt.isBefore(nextYearAutumnTerm.getStartDate())) {
            LocalDate start = dt;
            LocalDate end = dt = dt.plusWeeks(1L);
            weekNumber = autumnTerm.getAcademicWeekNumber(start);
            if (weekNumber <= 0) continue;
            weeks.add(Pair.of(weekNumber, LocalDateRange.of((LocalDate)start, (LocalDate)end)));
        }
        return weeks;
    }

    public void setTermDates(LinkedList<Term> termDates) {
        this.termDates = termDates;
    }

    public LinkedList<Term> getTermDates() {
        return this.termDates;
    }
}

