/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates;

import java.time.LocalDate;
import uk.ac.warwick.util.termdates.AcademicYear;
import uk.ac.warwick.util.termdates.AcademicYearPeriod;
import uk.ac.warwick.util.termdates.Term;

public class Vacation
extends AcademicYearPeriod {
    private Vacation(AcademicYearPeriod.PeriodType type, LocalDate firstDay, LocalDate lastDay) {
        this(null, type, firstDay, lastDay);
    }

    private Vacation(AcademicYear year, AcademicYearPeriod.PeriodType type, LocalDate firstDay, LocalDate lastDay) {
        super(year, type, firstDay, lastDay);
        if (!type.isValid(Vacation.class)) {
            throw new IllegalArgumentException((Object)((Object)type) + " isn't valid for Vacations");
        }
    }

    @Override
    Vacation withYear(AcademicYear year) {
        return new Vacation(year, this.getType(), this.getFirstDay(), this.getLastDay());
    }

    static Vacation between(AcademicYearPeriod.PeriodType type, Term before, Term after) {
        return new Vacation(type, before.getLastDay().plusDays(1L), after.getFirstDay().minusDays(1L));
    }

    static Vacation between(AcademicYearPeriod.PeriodType type, LocalDate firstDay, Term after) {
        return new Vacation(type, firstDay, after.getFirstDay().minusDays(1L));
    }

    static Vacation between(AcademicYearPeriod.PeriodType type, Term before, LocalDate lastDay) {
        return new Vacation(type, before.getLastDay().plusDays(1L), lastDay);
    }
}

