/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.termdates;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import uk.ac.warwick.util.termdates.AcademicWeek;
import uk.ac.warwick.util.termdates.AcademicYear;
import uk.ac.warwick.util.termdates.Term;
import uk.ac.warwick.util.termdates.Vacation;

public abstract class AcademicYearPeriod
implements Comparable<AcademicYearPeriod>,
Serializable {
    private final AcademicYear year;
    private final PeriodType type;
    private final LocalDate firstDay;
    private final LocalDate lastDay;

    AcademicYearPeriod(AcademicYear year, PeriodType type, LocalDate firstDay, LocalDate lastDay) {
        this.year = year;
        this.type = type;
        this.firstDay = firstDay;
        this.lastDay = lastDay;
    }

    abstract AcademicYearPeriod withYear(AcademicYear var1);

    public final AcademicYear getYear() {
        return this.year;
    }

    public final PeriodType getType() {
        return this.type;
    }

    public final LocalDate getFirstDay() {
        return this.firstDay;
    }

    public final LocalDate getLastDay() {
        return this.lastDay;
    }

    public final List<AcademicWeek> getAcademicWeeks() {
        return this.year.getAcademicWeeks().stream().filter(week -> week.getWeekNumber() >= this.getFirstWeek().getWeekNumber() && week.getWeekNumber() <= this.getLastWeek().getWeekNumber()).collect(Collectors.toList());
    }

    public final AcademicWeek getFirstWeek() {
        return this.year.getAcademicWeek(this.firstDay);
    }

    public final AcademicWeek getLastWeek() {
        return this.year.getAcademicWeek(this.lastDay);
    }

    public final boolean isTerm() {
        return this.getType().isValid(Term.class);
    }

    public final boolean isVacation() {
        return this.getType().isValid(Vacation.class);
    }

    public final boolean isBefore(AcademicYearPeriod other) {
        return this.compareTo(other) < 0;
    }

    public final boolean isAfter(AcademicYearPeriod other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public final int compareTo(AcademicYearPeriod o) {
        return this.firstDay.compareTo(o.firstDay);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcademicYearPeriod that = (AcademicYearPeriod)o;
        return new EqualsBuilder().append((Object)this.year, (Object)that.year).append((Object)this.type, (Object)that.type).append((Object)this.firstDay, (Object)that.firstDay).append((Object)this.lastDay, (Object)that.lastDay).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.year).append((Object)this.type).append((Object)this.firstDay).append((Object)this.lastDay).toHashCode();
    }

    public final String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("year", (Object)this.year).append("type", (Object)this.type).append("firstDay", (Object)this.firstDay).append("lastDay", (Object)this.lastDay).toString();
    }

    public static enum PeriodType {
        preTermVacation("Pre-term vacation", Vacation.class),
        autumnTerm("Autumn", Term.class),
        christmasVacation("Christmas vacation", Vacation.class),
        springTerm("Spring", Term.class),
        easterVacation("Easter vacation", Vacation.class),
        summerTerm("Summer", Term.class),
        summerVacation("Summer vacation", Vacation.class);

        private final String title;
        private final Class<? extends AcademicYearPeriod> validClass;

        private PeriodType(String title, Class<? extends AcademicYearPeriod> validClass) {
            this.title = title;
            this.validClass = validClass;
        }

        boolean isValid(Class<? extends AcademicYearPeriod> clazz) {
            return this.validClass == clazz;
        }

        public String toString() {
            return this.title;
        }

        public int getTermNumber() {
            if (!this.isValid(Term.class)) {
                throw new IllegalStateException("Not a term");
            }
            switch (this) {
                case autumnTerm: {
                    return 1;
                }
                case springTerm: {
                    return 2;
                }
                case summerTerm: {
                    return 3;
                }
            }
            throw new IllegalStateException("Not a term");
        }
    }
}

