/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.queue.conversion;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import uk.ac.warwick.util.queue.conversion.ItemType;
import uk.ac.warwick.util.queue.conversion.JsonObjectConverter;

public class AnnotationJsonObjectConverter
implements JsonObjectConverter,
BeanFactoryAware {
    private final Logger LOGGER = LoggerFactory.getLogger(AnnotationJsonObjectConverter.class);
    private Map<String, Class<?>> mappings = new HashMap();
    private ObjectMapper objectMapper = new ObjectMapper();
    private AutowireCapableBeanFactory beanFactory;

    @Override
    public Object fromJson(String type, JSONObject json) {
        try {
            Object object = this.objectMapper.readValue(json.toString(), this.mappings.get(type));
            if (this.beanFactory != null) {
                this.wire(object);
            }
            return object;
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void wire(Object object) {
        ArrayList<Object> candidates = new ArrayList<Object>();
        this.gatherObjects(candidates, object);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Recursively collected " + candidates.size() + " objects to wire");
        }
        for (Object e : candidates) {
            this.beanFactory.autowireBean(e);
        }
    }

    private void gatherObjects(List<Object> objs, Object obj) {
        objs.add(obj);
        BeanWrapperImpl wrapper = new BeanWrapperImpl(obj);
        for (PropertyDescriptor prop : wrapper.getPropertyDescriptors()) {
            Object value;
            Class<?> propertyType = prop.getPropertyType();
            if (propertyType.isPrimitive() || propertyType.equals(String.class) || "class".equals(prop.getName())) continue;
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Found non-primitive field " + prop.getName() + " with type " + propertyType);
            }
            if ((value = wrapper.getPropertyValue(prop.getName())) == null) continue;
            if (propertyType.isArray()) {
                Object[] array = null;
                try {
                    array = (Object[])value;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (array == null) continue;
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Looping through array");
                }
                for (Object o : array) {
                    this.gatherObjects(objs, o);
                }
                continue;
            }
            if (Iterable.class.isAssignableFrom(propertyType)) {
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Looping through Iterable");
                }
                for (Object o : (Iterable)value) {
                    this.gatherObjects(objs, o);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(propertyType)) {
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Looping through Map values");
                }
                for (Object o : ((Map)value).values()) {
                    this.gatherObjects(objs, o);
                }
                continue;
            }
            this.gatherObjects(objs, value);
        }
    }

    @Override
    public boolean supports(Object o) {
        return o.getClass().getAnnotation(ItemType.class) != null;
    }

    @Override
    public JSONObject toJson(Object o) {
        try {
            return new JSONObject(this.objectMapper.writeValueAsString(o));
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void registerType(String value, Class<?> c) {
        this.mappings.put(value, c);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (AutowireCapableBeanFactory)beanFactory;
    }
}

