/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model.request;

import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import uk.ac.warwick.userlookup.UserLookupInterface;
import uk.ac.warwick.util.mywarwick.model.request.Activity;
import uk.ac.warwick.util.mywarwick.model.request.ActivityFactory;

@Named(value="myWarwickActivityFactory")
@Singleton
public class ActivityFactoryImpl
implements ActivityFactory {
    private final UserLookupInterface userLookupInterface;

    @Inject
    ActivityFactoryImpl(UserLookupInterface userLookupInterface) {
        this.userLookupInterface = userLookupInterface;
    }

    @Override
    public Activity newActivity() {
        return this.assignService(new Activity());
    }

    @Override
    public Activity newActivity(@NotNull String userId, @NotNull String title, String url, String text, @NotNull String type) {
        return this.assignService(new Activity(userId, title, url, text, type));
    }

    @Override
    public Activity newActivity(@NotNull Set<String> userIds, @NotNull String title, String url, String text, @NotNull String type) {
        return this.assignService(new Activity(userIds, title, url, text, type));
    }

    @Override
    public Activity newActivity(@NotNull Set<String> userIds, @NotNull Set<String> groups, @NotNull String title, String url, String text, @NotNull String type) {
        return this.assignService(new Activity(userIds, groups, title, url, text, type));
    }

    private Activity assignService(Activity activity) {
        return activity.setGroupService(this.userLookupInterface.getGroupService()).setUserLookupInterface(this.userLookupInterface);
    }
}

