/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick.model;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Instance {
    private static final String USERCODE_REPLACE_STRING = ":usercode";
    private String baseUrl;
    private String providerId;
    private String apiUser;
    private String apiPassword;
    private boolean logErrors = true;
    private String activityPath;
    private String notificationPath;
    private String transientPushPath;
    private String hasPushRegistrationPath;

    public Instance() {
    }

    public Instance(String baseUrl, String providerId, String apiUser, String apiPassword, String logErrors) {
        this.baseUrl = baseUrl;
        this.providerId = providerId;
        this.apiUser = apiUser;
        this.apiPassword = apiPassword;
        if (logErrors != null) {
            this.logErrors = Boolean.parseBoolean(logErrors);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getApiUser() {
        return this.apiUser;
    }

    public String getApiPassword() {
        return this.apiPassword;
    }

    public boolean isLogErrors() {
        return this.logErrors;
    }

    public String getActivityPath() {
        if (this.activityPath == null) {
            this.activityPath = this.baseUrl + "/api/streams/" + this.providerId + "/activities";
        }
        return this.activityPath;
    }

    public String getNotificationPath() {
        if (this.notificationPath == null) {
            this.notificationPath = this.baseUrl + "/api/streams/" + this.providerId + "/notifications";
        }
        return this.notificationPath;
    }

    public String getTransientPushPath() {
        if (this.transientPushPath == null) {
            this.transientPushPath = this.baseUrl + "/api/push/" + this.providerId;
        }
        return this.transientPushPath;
    }

    public String getHasPushRegistrationPath() {
        if (this.hasPushRegistrationPath == null) {
            this.hasPushRegistrationPath = this.baseUrl + "/api/hasMobileRegistration/" + USERCODE_REPLACE_STRING;
        }
        return this.hasPushRegistrationPath;
    }

    public String getUsercodeReplaceString() {
        return USERCODE_REPLACE_STRING;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public void setApiUser(String apiUser) {
        this.apiUser = apiUser;
    }

    public void setApiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instance instance = (Instance)o;
        return new EqualsBuilder().append((Object)this.getBaseUrl(), (Object)instance.getBaseUrl()).append((Object)this.getProviderId(), (Object)instance.getProviderId()).append((Object)this.getApiUser(), (Object)instance.getApiUser()).append((Object)this.getApiPassword(), (Object)instance.getApiPassword()).append(this.isLogErrors(), instance.isLogErrors()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getBaseUrl()).append((Object)this.getProviderId()).append((Object)this.getApiUser()).append((Object)this.getApiPassword()).append(this.isLogErrors()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("baseUrl", (Object)this.baseUrl).append("providerId", (Object)this.providerId).append("apiUser", (Object)this.apiUser).append("activityPath", (Object)this.activityPath).append("notificationPath", (Object)this.notificationPath).append("logErrors", this.logErrors).toString();
    }
}

