/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Named;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Profile;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import uk.ac.warwick.util.mywarwick.healthcheck.SpringMyWarwickQuartzHealthcheckProvider;
import uk.ac.warwick.util.mywarwick.model.Configuration;
import uk.ac.warwick.util.mywarwick.model.PropertiesConfiguration;

@org.springframework.context.annotation.Configuration
@ComponentScan(value={"uk.ac.warwick.util.mywarwick"})
public class MyWarwickSpringConfig {
    @Bean
    @Conditional(value={ConfigurationMissingCondition.class})
    public Configuration myWarwickServiceConfiguration(@Named(value="applicationPropertiesForMyWarwick") Properties propertiesBean) {
        return new PropertiesConfiguration(propertiesBean);
    }

    public static class HealthcheckClassesPresent
    implements Condition {
        private static final Logger LOGGER = LoggerFactory.getLogger(HealthcheckClassesPresent.class);

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ClassLoader classLoader = context.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassUtils.getDefaultClassLoader();
            }
            try {
                Class.forName("uk.ac.warwick.util.service.ServiceHealthcheckProvider", true, classLoader);
                Class.forName("org.quartz.Scheduler", true, classLoader);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("HealthcheckClassesPresent condition resolving to true");
                }
                return true;
            }
            catch (Throwable t) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("HealthcheckClassesPresent condition resolving to false", t);
                }
                return false;
            }
        }
    }

    public static class ConfigurationMissingCondition
    implements ConfigurationCondition {
        private static final List<String> configurationClassNames = new ArrayList<String>(){
            {
                this.add("uk.ac.warwick.util.mywarwick.model.TypesafeConfiguration");
                this.add("uk.ac.warwick.util.mywarwick.model.SpringEnvironmentConfiguration");
                this.add("uk.ac.warwick.util.mywarwick.model.PropertiesConfiguration");
            }
        };

        public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            String[] beanNames = conditionContext.getRegistry().getBeanDefinitionNames();
            return Arrays.stream(beanNames).noneMatch(name -> {
                BeanDefinition def = conditionContext.getRegistry().getBeanDefinition(name);
                return configurationClassNames.stream().anyMatch(configClassName -> Objects.equals(configClassName, def.getBeanClassName()));
            });
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }
    }

    @org.springframework.context.annotation.Configuration
    @Conditional(value={HealthcheckClassesPresent.class})
    @Profile(value={"scheduling"})
    public static class HealthcheckConfig {
        @Bean
        public SpringMyWarwickQuartzHealthcheckProvider myWarwickQuartzHealthcheckProvider(@Autowired Scheduler scheduler, @Autowired Configuration myWarwickServiceConfiguration) {
            return new SpringMyWarwickQuartzHealthcheckProvider(scheduler, myWarwickServiceConfiguration);
        }
    }
}

