/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mywarwick;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import uk.ac.warwick.util.mywarwick.MyWarwickHttpResponseCallbackHelper;
import uk.ac.warwick.util.mywarwick.model.Instance;
import uk.ac.warwick.util.mywarwick.model.response.Response;

public class MyWarwickHttpResponseCallback
implements FutureCallback<HttpResponse> {
    private final String reqPath;
    private final String reqJson;
    private final Instance myWarwickInstance;
    private final Logger logger;
    private final ObjectMapper mapper;
    private final CompletableFuture<Response> completableFuture;
    private Response response;
    private MyWarwickHttpResponseCallbackHelper myWarwickHttpResponseCallbackHelper;

    MyWarwickHttpResponseCallback(@NotNull String reqPath, @NotNull String reqJson, @NotNull Instance myWarwickInstance, @NotNull Logger logger, @NotNull CompletableFuture<Response> completableFuture, @NotNull MyWarwickHttpResponseCallbackHelper myWarwickHttpResponseCallbackHelper) {
        this.reqPath = reqPath;
        this.reqJson = reqJson;
        this.myWarwickInstance = myWarwickInstance;
        this.logger = logger;
        this.completableFuture = completableFuture;
        this.mapper = new ObjectMapper();
        this.response = new Response();
        this.myWarwickHttpResponseCallbackHelper = myWarwickHttpResponseCallbackHelper;
    }

    public void completed(HttpResponse httpResponse) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Request completed");
        }
        try {
            this.response = this.myWarwickHttpResponseCallbackHelper.parseHttpResponseToResponseObject(httpResponse, this.mapper);
            this.completeFuture();
            if (this.response.getErrors().size() != 0) {
                this.logError("Request completed but it contains error(s):\nbaseUrl:" + this.myWarwickInstance.getBaseUrl() + "\nHTTP Status Code: " + httpResponse.getStatusLine().getStatusCode() + "\nResponse:\n" + this.response.toString());
            }
            if (this.response.getWarnings().size() != 0) {
                this.logger.warn("Request completed but it contains warning(s):\nbaseUrl:" + this.myWarwickInstance.getBaseUrl() + "\nHTTP Status Code: " + httpResponse.getStatusLine().getStatusCode() + "\nResponse:\n" + this.response.toString());
            }
        }
        catch (IOException e) {
            this.logError("An IOException was thrown communicating with My Warwick:\n" + e.getMessage() + "\nbaseUrl: " + this.myWarwickInstance.getBaseUrl());
            this.completableFuture.completeExceptionally(e);
        }
    }

    public void failed(Exception e) {
        this.logError("Request to My Warwick API has failed with errors:\npath: " + this.reqPath + "\ninstance: " + this.myWarwickInstance + "\nrequest json " + this.reqJson + "\nerror message:" + e.getMessage(), e);
        this.completableFuture.completeExceptionally(e);
    }

    public void cancelled() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Request to My Warwick has been cancelled");
        }
        this.completableFuture.cancel(true);
    }

    private void logError(String message) {
        if (this.myWarwickInstance.isLogErrors()) {
            this.logger.error(message);
        } else {
            this.logger.warn(message);
        }
    }

    private void logError(String message, Exception e) {
        if (this.myWarwickInstance.isLogErrors()) {
            this.logger.error(message, (Throwable)e);
        } else {
            this.logger.warn(message, (Throwable)e);
        }
    }

    private void completeFuture() {
        if (!this.myWarwickInstance.isLogErrors()) {
            this.response.setErrors(Collections.emptyList());
        }
        this.completableFuture.complete(this.response);
    }
}

