/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.mail;

import java.io.IOException;
import java.util.Stack;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.util.StringUtils;

public class MimeMessageUtilities {
    public static String mimeMessageToString(MimeMessage message, boolean logBody) throws MessagingException, IOException {
        StringBuilder sb = new StringBuilder("MimeMessage: ");
        sb.append("from=").append(StringUtils.arrayToCommaDelimitedString((Object[])message.getFrom())).append("; ");
        sb.append("replyTo=").append(StringUtils.arrayToCommaDelimitedString((Object[])message.getReplyTo())).append("; ");
        sb.append("to=").append(StringUtils.arrayToCommaDelimitedString((Object[])message.getRecipients(MimeMessage.RecipientType.TO))).append("; ");
        sb.append("cc=").append(StringUtils.arrayToCommaDelimitedString((Object[])message.getRecipients(MimeMessage.RecipientType.CC))).append("; ");
        sb.append("bcc=").append(StringUtils.arrayToCommaDelimitedString((Object[])message.getRecipients(MimeMessage.RecipientType.BCC))).append("; ");
        sb.append("sentDate=").append(message.getSentDate()).append("; ");
        sb.append("subject=").append(message.getSubject()).append("; ");
        sb.append("text=");
        if (logBody) {
            if (message.getContent() instanceof MimeMultipart) {
                MimeMultipart multipartMessage = (MimeMultipart)message.getContent();
                MimeMessageUtilities.processMultipartMessage(sb, multipartMessage);
            } else {
                sb.append(message.getContent());
            }
        } else {
            sb.append("[Redacted, logBody=false]");
        }
        return sb.toString();
    }

    private static void processMultipartMessage(StringBuilder sb, MimeMultipart multipartMessage) throws MessagingException, IOException {
        Stack<BodyPart> bodies = new Stack<BodyPart>();
        for (int i = 0; i < multipartMessage.getCount(); ++i) {
            bodies.push(multipartMessage.getBodyPart(i));
        }
        while (!bodies.empty()) {
            BodyPart current = (BodyPart)bodies.pop();
            if (current.isMimeType("text/plain") || current.isMimeType("text/html")) {
                sb.append("[").append(current.getContentType()).append("] ").append(current.getContent());
                continue;
            }
            if (!(current.getContent() instanceof BodyPart)) continue;
            bodies.push((BodyPart)current.getContent());
            sb.append("\n----------\n");
        }
    }
}

