/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.logging;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"uk.ac.warwick.AUDIT");
    private final String applicationKey;

    private AuditLogger(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public void log(RequestInformation info) {
        this.log(info, null);
    }

    public void log(final RequestInformation info, Map<Field, Object> data) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(Field.eventType.getValue(), info.eventType);
        if (info.username != null) {
            map.put(Field.username.getValue(), info.username);
        }
        if (info.ipAddress != null) {
            map.put(Field.ipAddress.getValue(), info.ipAddress);
        }
        if (info.userAgent != null) {
            map.put("request_headers", new LinkedHashMap<String, Object>(){
                {
                    this.put("user-agent", info.userAgent);
                }
            });
        }
        if (data != null) {
            map.put(this.applicationKey, data.entrySet().stream().collect(HashMap::new, (m, e) -> m.put(((Field)e.getKey()).getValue(), e.getValue()), HashMap::putAll));
        }
        LOGGER.info("{}", (Object)StructuredArguments.entries(map));
    }

    public static AuditLogger getAuditLogger(String applicationKey) {
        if (!applicationKey.matches("^[a-z]+$")) {
            throw new IllegalArgumentException("Application key must be all lowercase characters");
        }
        return new AuditLogger(applicationKey);
    }

    public static class RequestInformation {
        private final String eventType;
        private String username;
        private String userAgent;
        private String ipAddress;

        private RequestInformation(String eventType) {
            this.eventType = eventType;
        }

        public static RequestInformation forEventType(String eventType) {
            return new RequestInformation(eventType);
        }

        public RequestInformation withUsername(@NotNull String username) {
            if (username == null) {
                throw new IllegalArgumentException();
            }
            this.username = username;
            return this;
        }

        public RequestInformation withUserAgent(@NotNull String userAgent) {
            if (userAgent == null) {
                throw new IllegalArgumentException();
            }
            this.userAgent = userAgent;
            return this;
        }

        public RequestInformation withIpAddress(@NotNull String ipAddress) {
            if (ipAddress == null) {
                throw new IllegalArgumentException();
            }
            this.ipAddress = ipAddress;
            return this;
        }
    }

    public static final class Field {
        private static final Field eventType = new Field("event_type");
        private static final Field username = new Field("username");
        private static final Field ipAddress = new Field("source_ip");
        private String value;

        public Field(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return other != null && other instanceof Field && ((Field)other).value.equals(this.value);
        }
    }
}

