/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.hibernate4;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Set;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.hibernate.BatchResults;
import uk.ac.warwick.util.hibernate4.BatchResults;

public final class BatchResultsImpl<T>
implements BatchResults<T> {
    private final Set<String> idents = Sets.newHashSet();
    private final ScrollableResults delegate;
    private final int batchSize;
    private final Function<? super T, String> identifier;
    private final Session session;

    public BatchResultsImpl(ScrollableResults theDelegate, int theBatchSize, Function<? super T, String> idFunction, Session theSession) {
        this.delegate = theDelegate;
        this.identifier = idFunction;
        this.batchSize = theBatchSize;
        this.session = theSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWithBatch(BatchResults.Callback<T> callback) throws Exception {
        try {
            int i = 0;
            while (this.delegate.next()) {
                Object entity = this.delegate.get(0);
                String id = (String)this.identifier.apply(entity);
                if (!StringUtils.hasText(id)) {
                    throw new Exception("Entity did not return a valid unique ID");
                }
                if (this.idents.add(id)) {
                    callback.run(entity);
                }
                if (++i <= this.batchSize) continue;
                this.session.clear();
                i = 0;
            }
        }
        finally {
            this.delegate.close();
        }
    }
}

