/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.hibernate4;

import java.util.List;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class AnnotationFilteringEventListener
implements PostLoadEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener {
    private static final long serialVersionUID = 8652156835267250103L;
    private final List<ObjectListener> listeners;
    private final Class<?> annotationClass;

    public AnnotationFilteringEventListener(String clazz, List<ObjectListener> theListeners) throws ClassNotFoundException {
        this.annotationClass = Class.forName(clazz);
        this.listeners = theListeners;
    }

    public void onPostLoad(PostLoadEvent event) {
        Object loadedObject = event.getEntity();
        this.handleLoadedObject(loadedObject);
    }

    public void onPostInsert(PostInsertEvent event) {
        Object savedObject = event.getEntity();
        this.handleSavedOrUpdatedObject(savedObject);
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object savedObject = event.getEntity();
        this.handleSavedOrUpdatedObject(savedObject);
    }

    public void onPostDelete(PostDeleteEvent event) {
        Object deletedObject = event.getEntity();
        this.handleDeletedObject(deletedObject);
    }

    void handleLoadedObject(Object object) {
        boolean objectHasAnnotation = this.objectHasAnnotation(object.getClass());
        if (objectHasAnnotation) {
            for (ObjectListener listener : this.listeners) {
                if (!(listener instanceof LoadedObjectListener)) continue;
                ((LoadedObjectListener)listener).loaded(object);
            }
        }
    }

    void handleDeletedObject(Object object) {
        boolean objectHasAnnotation = this.objectHasAnnotation(object.getClass());
        if (objectHasAnnotation) {
            for (ObjectListener listener : this.listeners) {
                if (!(listener instanceof DeletedObjectListener)) continue;
                ((DeletedObjectListener)listener).deleted(object);
            }
        }
    }

    void handleSavedOrUpdatedObject(Object object) {
        boolean objectHasAnnotation = this.objectHasAnnotation(object.getClass());
        if (objectHasAnnotation) {
            for (ObjectListener listener : this.listeners) {
                if (!(listener instanceof SavedOrUpdatedObjectListener)) continue;
                ((SavedOrUpdatedObjectListener)listener).savedOrUpdated(object);
            }
        }
    }

    private boolean objectHasAnnotation(Class loadedClass) {
        return loadedClass.getAnnotation(this.annotationClass) != null;
    }

    public boolean requiresPostCommitHanding(EntityPersister entityPersister) {
        return true;
    }

    public static interface DeletedObjectListener
    extends ObjectListener {
        public void deleted(Object var1);
    }

    public static interface SavedOrUpdatedObjectListener
    extends ObjectListener {
        public void savedOrUpdated(Object var1);
    }

    public static interface LoadedObjectListener
    extends ObjectListener {
        public void loaded(Object var1);
    }

    public static interface ObjectListener {
    }
}

