/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import uk.ac.warwick.util.core.spring.FileUtils;
import uk.ac.warwick.util.files.FileData;
import uk.ac.warwick.util.files.FileStore;
import uk.ac.warwick.util.files.FileStoreStatistics;
import uk.ac.warwick.util.files.impl.DeletionBinHolder;
import uk.ac.warwick.util.files.impl.StatisticsRecordingByteSource;
import uk.ac.warwick.util.files.impl.StatisticsRecordingCharSource;

@Configurable
public abstract class AbstractFileBackedFileData
implements FileData {
    @Autowired(required=true)
    private DeletionBinHolder deletionBinHolder;
    private final FileStoreStatistics statistics;

    protected AbstractFileBackedFileData(FileStore fileStore) {
        this.statistics = fileStore.getStatistics();
    }

    @Override
    public final boolean isExists() {
        return this.getFile().exists();
    }

    @Override
    public ByteSource asByteSource() {
        return Files.asByteSource((File)this.getFile());
    }

    @Override
    public long length() {
        return this.isExists() ? this.getFile().length() : 0L;
    }

    @Override
    public final URI getFileLocation() {
        return this.getFile().toURI();
    }

    @Override
    public final boolean isFileBacked() {
        return true;
    }

    @Override
    public final boolean delete() {
        if (!this.isExists()) {
            return true;
        }
        FileUtils.recursiveDelete(this.getFile(), this.deletionBinHolder.getDeletionBinDirectory());
        return true;
    }

    public abstract File getFile();

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        return this.getFile().toString();
    }

    public final DeletionBinHolder getDeletionBinHolder() {
        return this.deletionBinHolder;
    }

    public final void setDeletionBinHolder(DeletionBinHolder deletionBinHolder) {
        this.deletionBinHolder = deletionBinHolder;
    }

    protected class FileBackedCharSource
    extends StatisticsRecordingCharSource {
        private final Charset charset;
        private final FileBackedByteSource byteSource;

        private FileBackedCharSource(Charset charset, FileBackedByteSource byteSource) {
            super(AbstractFileBackedFileData.this.statistics);
            this.charset = (Charset)Preconditions.checkNotNull((Object)charset);
            this.byteSource = (FileBackedByteSource)((Object)Preconditions.checkNotNull((Object)((Object)byteSource)));
        }

        public Reader openStream() throws IOException {
            return new InputStreamReader(this.byteSource.openStream(), this.charset);
        }

        public String toString() {
            return this.byteSource.toString() + ".asCharSource(" + this.charset + ")";
        }
    }

    protected class FileBackedByteSource
    extends StatisticsRecordingByteSource {
        private final File file;

        private FileBackedByteSource(File file) {
            super(AbstractFileBackedFileData.this.statistics);
            this.file = (File)Preconditions.checkNotNull((Object)file);
        }

        public InputStream openStream() throws IOException {
            return Files.asByteSource((File)this.file).openStream();
        }

        public long size() throws IOException {
            return Files.asByteSource((File)this.file).size();
        }

        @Override
        public byte[] read() throws IOException {
            return AbstractFileBackedFileData.this.statistics.time(() -> Files.asByteSource((File)this.file).read(), AbstractFileBackedFileData.this.statistics::referenceRead);
        }

        public CharSource asCharSource(Charset charset) {
            return new FileBackedCharSource(charset, this);
        }

        public String toString() {
            return "FileBackedByteSource.asByteSource(" + this.file + ")";
        }
    }
}

