/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import java.io.OutputStream;

class LengthCountingOutputStream
extends OutputStream {
    private int count = 0;

    LengthCountingOutputStream() {
    }

    @Override
    public void write(int i) {
        ++this.count;
    }

    @Override
    public void write(byte[] bytes) {
        this.count += bytes.length;
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset >= 0 && offset <= bytes.length && length >= 0 && offset + length <= bytes.length && offset + length >= 0) {
            this.count += length;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public int length() {
        return this.count;
    }
}

