/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.core.spring.FileUtils;
import uk.ac.warwick.util.files.LocalFileReference;
import uk.ac.warwick.util.files.LocalFileStore;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.imageresize.ImageResizer;

public final class CachingImageResizer
implements ImageResizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingImageResizer.class);
    private final ImageResizer delegate;
    private final ImageCache cache;

    CachingImageResizer(ImageResizer delegateResizer, ImageCache theCache) {
        this.delegate = delegateResizer;
        this.cache = theCache;
    }

    public CachingImageResizer(ImageResizer delegateResizer, LocalFileStore fileStore, Storeable.StorageStrategy storageStrategy) {
        this(delegateResizer, new FileStoreScaledImageCache(fileStore, storageStrategy));
    }

    @Override
    public void renderResized(ByteSource source, HashString hash, ZonedDateTime entityLastModified, OutputStream out, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
        if (this.cache.contains(hash, entityLastModified, maxWidth, maxHeight)) {
            this.cache.serveFromCache(hash, entityLastModified, out, maxWidth, maxHeight);
        } else {
            this.cache.cacheAndServe(source, hash, entityLastModified, out, maxWidth, maxHeight, fileType, this.delegate);
        }
    }

    @Override
    public long getResizedImageLength(ByteSource source, HashString hash, ZonedDateTime entityLastModified, int maxWidth, int maxHeight, ImageResizer.FileType fileType) {
        return this.cache.getFileSize(source, hash, entityLastModified, maxWidth, maxHeight, fileType, this.delegate);
    }

    static class FileStoreScaledImageCache
    implements ImageCache {
        private final LocalFileStore fileStore;
        private final Storeable.StorageStrategy storageStrategy;

        FileStoreScaledImageCache(LocalFileStore fileStore, Storeable.StorageStrategy storageStrategy) {
            this.fileStore = fileStore;
            this.storageStrategy = storageStrategy;
        }

        @Override
        public void cacheAndServe(ByteSource source, HashString hash, ZonedDateTime entityLastModified, OutputStream out, int maxWidth, int maxHeight, ImageResizer.FileType fileType, ImageResizer resizer) throws IOException {
            try {
                this.createInCache(source, hash, entityLastModified, maxWidth, maxHeight, fileType, resizer);
                this.serveFromCache(hash, entityLastModified, out, maxWidth, maxHeight);
            }
            catch (IOException e) {
                LOGGER.error("Unable to update rendered image cache for " + this.getCacheFile(hash, maxWidth, maxHeight), (Throwable)e);
                resizer.renderResized(source, hash, entityLastModified, out, maxWidth, maxHeight, fileType);
            }
        }

        @Override
        public void serveFromCache(HashString hash, ZonedDateTime entityLastModified, OutputStream out, int maxWidth, int maxHeight) throws IOException {
            this.getCacheFile(hash, maxWidth, maxHeight).asByteSource().copyTo(out);
        }

        @Override
        public long getFileSize(ByteSource source, HashString hash, ZonedDateTime entityLastModified, int maxWidth, int maxHeight, ImageResizer.FileType fileType, ImageResizer resizer) {
            try {
                if (!this.contains(hash, entityLastModified, maxWidth, maxHeight)) {
                    this.createInCache(source, hash, entityLastModified, maxWidth, maxHeight, fileType, resizer);
                }
                return this.getCacheFile(hash, maxWidth, maxHeight).length();
            }
            catch (IOException e) {
                return -1L;
            }
        }

        @Override
        public boolean contains(HashString hash, ZonedDateTime entityLastModified, int maxWidth, int maxHeight) {
            LocalFileReference candidate = this.getCacheFile(hash, maxWidth, maxHeight);
            if (candidate.isExists()) {
                LOGGER.debug("Cache file " + candidate + " exists and is readable");
                if (entityLastModified.toInstant().isBefore(candidate.getLastModified())) {
                    LOGGER.debug("Cache file is not stale; returning cache hit");
                    return true;
                }
            }
            return false;
        }

        private LocalFileReference getCacheFile(HashString hash, int maxWidth, int maxHeight) {
            try {
                String path = hash.toString() + "@" + maxWidth + "x" + maxHeight;
                return this.fileStore.getForPath(this.storageStrategy, path);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createInCache(ByteSource source, HashString hash, ZonedDateTime entityLastModified, int maxWidth, int maxHeight, ImageResizer.FileType fileType, ImageResizer resizer) throws IOException {
            File tempFile = File.createTempFile(hash.toString(), "@" + maxWidth + "x" + maxHeight);
            try {
                try (FileOutputStream fos = new FileOutputStream(tempFile);){
                    resizer.renderResized(source, hash, entityLastModified, fos, maxWidth, maxHeight, fileType);
                }
                LocalFileReference newCacheEntry = this.getCacheFile(hash, maxWidth, maxHeight);
                newCacheEntry.overwrite(Files.asByteSource((File)tempFile));
            }
            finally {
                FileUtils.recursiveDelete(tempFile, false);
            }
        }
    }

    static interface ImageCache {
        public void cacheAndServe(ByteSource var1, HashString var2, ZonedDateTime var3, OutputStream var4, int var5, int var6, ImageResizer.FileType var7, ImageResizer var8) throws IOException;

        public void serveFromCache(HashString var1, ZonedDateTime var2, OutputStream var3, int var4, int var5) throws IOException;

        public long getFileSize(ByteSource var1, HashString var2, ZonedDateTime var3, int var4, int var5, ImageResizer.FileType var6, ImageResizer var7);

        public boolean contains(HashString var1, ZonedDateTime var2, int var3, int var4);
    }
}

