/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import uk.ac.warwick.util.collections.Pair;

public final class StopWatch {
    public static final Comparator<Task> TIME_COMPARATOR = new Comparator<Task>(){

        @Override
        public int compare(Task arg0, Task arg1) {
            return Long.valueOf(arg1.timeMillis).compareTo(arg0.timeMillis);
        }
    };
    private static final double MAX_PERCENTAGE = 100.0;
    private static final double MILLISECONDS_IN_SECOND = 1000.0;
    private static final int DEFAULT_DISPLAY_MS_THRESHOLD = 10;
    private final List<Task> taskList = new LinkedList<Task>();
    private int taskCount;
    private long totalTimeMillis;
    private int displayThresholdInMs = 10;

    public void start(String taskName) throws IllegalStateException {
        if (this.hasRunningTask()) {
            this.getCurrentTask().addAndStartSubTask(taskName);
        } else {
            Task task = new Task(taskName, this);
            task.start();
            this.taskList.add(task);
        }
    }

    public long stop() throws IllegalStateException {
        if (this.hasRunningTask()) {
            long lastTime = this.getCurrentTask().stop().getRight();
            if (!this.getCurrentTask().isRunning()) {
                this.totalTimeMillis += lastTime;
                ++this.taskCount;
            }
            return lastTime;
        }
        return -1L;
    }

    public Task getCurrentTask() {
        if (this.taskList.isEmpty()) {
            return null;
        }
        return this.taskList.get(this.taskList.size() - 1);
    }

    public boolean hasRunningTask() {
        Task task = this.getCurrentTask();
        if (task == null) {
            return false;
        }
        return task.isRunning();
    }

    void setTotalTimeMillis(long totalTime) {
        this.totalTimeMillis = totalTime;
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public double getTotalTimeSeconds() {
        return (double)this.totalTimeMillis / 1000.0;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public Task[] getTaskInfo() {
        return this.taskList.toArray(new Task[this.taskList.size()]);
    }

    public String shortSummary() {
        return "StopWatch: running time (millis) = " + this.getTotalTimeMillis();
    }

    public String prettyPrint() {
        StringBuffer sb = new StringBuffer(this.shortSummary());
        sb.append('\n');
        sb.append("---------------------------------------------------\n");
        sb.append("ms       %       Task name\n");
        sb.append("---------------------------------------------------\n");
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(false);
        NumberFormat pf = NumberFormat.getPercentInstance();
        pf.setGroupingUsed(false);
        Collections.sort(this.taskList, TIME_COMPARATOR);
        for (Task task : this.taskList) {
            task.prettyPrint(sb, this.getTotalTimeSeconds(), nf, pf, 0);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.shortSummary());
        Task[] tasks = this.getTaskInfo();
        for (int i = 0; i < tasks.length; ++i) {
            sb.append("; [" + tasks[i].getTaskName() + "] took " + tasks[i].getTimeMillis());
            long percent = Math.round(100.0 * tasks[i].getTimeSeconds() / this.getTotalTimeSeconds());
            sb.append(" = " + percent + "%");
        }
        return sb.toString();
    }

    public void setDisplayThresholdInMs(int displayThresholdInMs) {
        this.displayThresholdInMs = displayThresholdInMs;
    }

    private int getDisplayMsThreshold() {
        return this.displayThresholdInMs;
    }

    public static final class Task {
        private static final double MILLISECONDS_IN_SECOND = 1000.0;
        private final String taskName;
        private final StopWatch sw;
        private long startTime;
        private long endTime;
        private long timeMillis;
        private boolean running;
        private List<Task> subTasks = new LinkedList<Task>();

        private Task(String theTaskName, StopWatch stopWatch) {
            this.taskName = theTaskName;
            this.sw = stopWatch;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
            this.running = true;
        }

        public void addAndStartSubTask(String theTaskName) {
            if (this.hasRunningSubTask()) {
                this.getCurrentSubTask().addAndStartSubTask(theTaskName);
            } else {
                Task task = new Task(theTaskName, this.sw);
                this.subTasks.add(task);
                task.start();
            }
        }

        public Pair<Boolean, Long> stop() {
            if (this.hasRunningSubTask()) {
                return this.getCurrentSubTask().stop();
            }
            this.endTime = System.currentTimeMillis();
            this.running = false;
            this.timeMillis = this.endTime - this.startTime;
            return Pair.of(true, this.timeMillis);
        }

        public boolean isRunning() {
            return this.running;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeMillis() {
            return this.timeMillis;
        }

        public double getTimeSeconds() {
            return (double)this.timeMillis / 1000.0;
        }

        public Task getCurrentSubTask() {
            if (this.subTasks.isEmpty()) {
                return null;
            }
            return this.subTasks.get(this.subTasks.size() - 1);
        }

        public boolean hasRunningSubTask() {
            Task subTask = this.getCurrentSubTask();
            if (subTask == null) {
                return false;
            }
            return subTask.isRunning();
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public List<Task> getSubTasks() {
            return this.subTasks;
        }

        public void setSubTasks(List<Task> subTasks) {
            this.subTasks = subTasks;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public void setTimeMillis(long timeMillis) {
            this.timeMillis = timeMillis;
        }

        public void prettyPrint(StringBuffer sb, double totalTimeSeconds, NumberFormat nf, NumberFormat pf, int tabs) {
            if (this.getTimeMillis() > (long)this.sw.getDisplayMsThreshold()) {
                for (int i = 0; i < tabs; ++i) {
                    sb.append("-");
                }
                if (tabs > 0) {
                    sb.append(">");
                }
                sb.append(nf.format(this.getTimeMillis()) + " ms   ");
                sb.append(pf.format(this.getTimeSeconds() / totalTimeSeconds) + "    ");
                sb.append(this.getTaskName());
                sb.append("\n");
                Collections.sort(this.subTasks, TIME_COMPARATOR);
                for (Task subTask : this.subTasks) {
                    subTask.prettyPrint(sb, totalTimeSeconds, nf, pf, tabs + 1);
                }
            }
        }
    }
}

