/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import uk.ac.warwick.util.collections.google.BasePredicate;

public final class HttpUtils {
    private static final HttpUtils INSTANCE = new HttpUtils();

    private HttpUtils() {
    }

    public static HttpUtils getInstance() {
        return INSTANCE;
    }

    public static String appendGetParameter(String url, String paramName, String paramValue) {
        String paramString;
        String result = url;
        try {
            paramString = paramName + "=" + URLEncoder.encode(paramValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("this should never happen!", e);
        }
        result = result.indexOf("?") == -1 ? result + "?" + paramString : result + "&" + paramString;
        return result;
    }

    public static boolean getBooleanRequestAttribute(ServletRequest request, String attributeName, boolean defaultValue) {
        Object value = request.getAttribute(attributeName);
        Boolean result = defaultValue;
        if (value != null && value instanceof Boolean) {
            result = (Boolean)value;
        }
        return result;
    }

    public static String trimTrailingSlash(String url) {
        int urlLength = url.length();
        if (!(urlLength == 1 && url.equals("/") || urlLength <= 0 || url.charAt(urlLength - 1) != '/')) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static boolean isAbsoluteAddress(String path) {
        boolean result;
        if (path.indexOf("/") == -1 || path.indexOf(".") == -1) {
            result = false;
        } else if (path.toLowerCase().startsWith("http://")) {
            result = true;
        } else {
            String beforeSlash = path.substring(0, path.indexOf(47));
            result = HttpUtils.isDomain(beforeSlash);
        }
        return result;
    }

    private static boolean isDomain(String domain) {
        StringTokenizer tokenizer = new StringTokenizer(domain, ".");
        return tokenizer.countTokens() > 1;
    }

    public static Cookie getCookie(Cookie[] cookies, String name) {
        if (cookies != null) {
            return HttpUtils.getCookie(Arrays.asList(cookies), name);
        }
        return null;
    }

    public static Cookie getCookie(Iterable<Cookie> cookies, final String name) {
        if (cookies != null) {
            try {
                return new BasePredicate<Cookie>(){

                    @Override
                    public boolean apply(Cookie cookie) {
                        return cookie.getName().equals(name);
                    }
                }.find(cookies);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        return null;
    }

    public static String utf8Encode(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String utf8Decode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

