/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.core;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import org.threeten.extra.Days;

public final class DateTimeUtils {
    public static Clock CLOCK_IMPLEMENTATION = Clock.systemDefaultZone();
    private static final int DAYS_PER_WEEK = 7;

    private DateTimeUtils() {
    }

    public static boolean equalsIgnoreTime(Temporal a, Temporal b) {
        return a.getLong(ChronoField.YEAR) == b.getLong(ChronoField.YEAR) && a.getLong(ChronoField.DAY_OF_YEAR) == b.getLong(ChronoField.DAY_OF_YEAR);
    }

    public static boolean isSameDay(Temporal a, Temporal b) {
        return DateTimeUtils.equalsIgnoreTime(a, b);
    }

    public static int getDifferenceInDays(Temporal a, Temporal b) {
        LocalDate start = LocalDate.from(a);
        LocalDate end = LocalDate.from(b);
        return Days.between((Temporal)start, (Temporal)end).getAmount();
    }

    public static int getDifferenceInWeeks(Temporal a, Temporal b) {
        int days = DateTimeUtils.getDifferenceInDays(a, b);
        int weeks = days / 7;
        if (days % 7 != 0) {
            ++weeks;
        }
        return weeks;
    }

    public static boolean isBetween(ChronoLocalDate dt, ChronoLocalDate earliest, ChronoLocalDate latest) {
        return dt.isEqual(earliest) || dt.isEqual(latest) || dt.isAfter(earliest) && dt.isBefore(latest);
    }

    public static boolean isBetween(ChronoLocalDateTime<?> dt, ChronoLocalDateTime<?> earliest, ChronoLocalDateTime<?> latest) {
        return dt.isEqual(earliest) || dt.isEqual(latest) || dt.isAfter(earliest) && dt.isBefore(latest);
    }

    public static boolean isBetween(ChronoZonedDateTime<?> dt, ChronoZonedDateTime<?> earliest, ChronoZonedDateTime<?> latest) {
        return dt.isEqual(earliest) || dt.isEqual(latest) || dt.isAfter(earliest) && dt.isBefore(latest);
    }

    public static void useMockDateTime(TemporalAccessor dt, Runnable fn) {
        try {
            CLOCK_IMPLEMENTATION = Clock.fixed(DateTimeUtils.toInstant(dt), ZoneId.systemDefault());
            fn.run();
        }
        finally {
            CLOCK_IMPLEMENTATION = Clock.systemDefaultZone();
        }
    }

    private static Instant toInstant(TemporalAccessor t) {
        if (t instanceof Instant) {
            return (Instant)t;
        }
        LocalDate date = TemporalQueries.localDate().queryFrom(t);
        LocalTime time = TemporalQueries.localTime().queryFrom(t);
        ZoneId zone = TemporalQueries.zone().queryFrom(t);
        ZoneOffset offset = TemporalQueries.offset().queryFrom(t);
        LocalDateTime datetime = date.atTime(time);
        if (zone != null) {
            return datetime.atZone(zone).toInstant();
        }
        if (offset != null) {
            return datetime.atOffset(offset).toInstant();
        }
        return datetime.atZone(ZoneId.systemDefault()).toInstant();
    }
}

