/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.convert;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Date;
import uk.ac.warwick.util.core.StringUtils;

public class S3ByteSource
extends ByteSource {
    private AmazonS3 s3;
    private String bucket;
    private String key;
    private final long offset;
    private final long length;
    private transient long s3ContentLength = -1L;

    public S3ByteSource(AmazonS3 s3, String bucket, String key) {
        this(s3, bucket, key, 0L);
    }

    public S3ByteSource(AmazonS3 s3, String bucket, String key, long offset) {
        this(s3, bucket, key, offset, Long.MAX_VALUE);
    }

    public S3ByteSource(AmazonS3 s3, String bucket, String key, long offset, long length) {
        this(s3, bucket, key, offset, length, -1L);
    }

    public S3ByteSource(AmazonS3 s3, String bucket, String key, long offset, long length, long s3ContentLength) {
        this.s3 = s3;
        this.bucket = bucket;
        this.key = key;
        this.offset = offset;
        this.length = length;
        this.s3ContentLength = s3ContentLength;
        this.validate();
    }

    private void validate() {
        if (this.s3 == null) {
            throw new IllegalArgumentException("Uninitialised Amazon S3 instance");
        }
        if (!StringUtils.hasText(this.bucket)) {
            throw new IllegalArgumentException("Missing Amazon S3 bucket name");
        }
        if (!StringUtils.hasText(this.key)) {
            throw new IllegalArgumentException("Missing Amazon S3 object name");
        }
    }

    private void checkExists() throws IOException {
        if (!this.s3.doesObjectExist(this.bucket, this.key)) {
            throw new IOException("Amazon S3 object not found");
        }
    }

    private long getS3ContentLength() {
        if (this.s3ContentLength < 0L) {
            this.s3ContentLength = this.s3.getObjectMetadata(this.bucket, this.key).getContentLength();
        }
        return this.s3ContentLength;
    }

    private long getEnd() {
        return this.offset + this.length - 1L;
    }

    private Date getS3LastModified() {
        return this.s3.getObjectMetadata(this.bucket, this.key).getLastModified();
    }

    public synchronized Instant getLastModified() throws IOException {
        this.checkExists();
        return this.getS3LastModified().toInstant();
    }

    public synchronized InputStream openStream() throws IOException {
        this.checkExists();
        GetObjectRequest req = new GetObjectRequest(this.bucket, this.key).withRange(this.offset, this.getEnd());
        return this.s3.getObject(req).getObjectContent();
    }

    public synchronized boolean isEmpty() {
        try {
            this.checkExists();
            return this.getS3ContentLength() > 0L;
        }
        catch (Exception e) {
            return true;
        }
    }

    public synchronized long size() {
        try {
            this.checkExists();
            return Math.min(this.length, this.getS3ContentLength() - this.offset);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public ByteSource slice(long offset, long length) {
        long newOffset = this.offset + offset;
        long newLength = Math.min(length, this.getEnd() - newOffset);
        return new S3ByteSource(this.s3, this.bucket, this.key, newOffset, newLength, this.getS3ContentLength());
    }

    public String toString() {
        return "S3ByteSource.asByteSource(" + this.bucket + "/" + this.key + ")";
    }
}

