/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.AbstractSquareTagTransformer;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlHandler;

public final class MediaUrlTransformer
extends AbstractSquareTagTransformer {
    static final String[] ALLOWED_PARAMETERS = new String[]{"height", "width", "type", "previewimage", "captions", "align", "download", "altplayer", "fallback", "fallbackversion", "stretching", "title", "description", "locktopath"};
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaUrlTransformer.class);
    private final Map<String, MediaUrlHandler> handlers;
    private final String closeButtonImgUrl;

    public MediaUrlTransformer(Map<String, MediaUrlHandler> theHandlers, String theCloseButtonImgUrl) {
        super("media");
        this.handlers = theHandlers;
        this.closeButtonImgUrl = theCloseButtonImgUrl;
    }

    @Override
    protected String[] getAllowedParameters() {
        return ALLOWED_PARAMETERS;
    }

    @Override
    protected boolean isTagGeneratesHead() {
        return true;
    }

    @Override
    protected TextPatternTransformer.Callback getCallback() {
        return new TextPatternTransformer.Callback(){

            @Override
            public String transform(String input, MutableContent mc) {
                Matcher matcher = MediaUrlTransformer.this.getTagPattern().matcher(input);
                if (!matcher.matches()) {
                    throw new IllegalStateException("Failed to match media tag, but shouldn't be here if it didn't");
                }
                Map parameters = MediaUrlTransformer.this.getParameters(matcher);
                String address = MediaUrlTransformer.this.getContents(matcher);
                String result = input;
                if (!parameters.containsKey("align")) {
                    parameters.put("align", "left");
                }
                parameters.put("random", new Random());
                parameters.put("closeButtonImgUrl", MediaUrlTransformer.this.closeButtonImgUrl);
                if (parameters.containsKey("type")) {
                    String contentType = parameters.get("type").toString();
                    try {
                        MediaUrlHandler handler = (MediaUrlHandler)MediaUrlTransformer.this.handlers.get(contentType);
                        result = handler.getHtml(address, parameters, mc);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Media URL with overridden type threw an exception: " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    for (MediaUrlHandler handler : MediaUrlTransformer.this.handlers.values()) {
                        if (!handler.recognises(address)) continue;
                        result = handler.getHtml(address, parameters, mc);
                        break;
                    }
                }
                return result;
            }
        };
    }
}

