/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import java.util.HashMap;
import java.util.Map;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.media.AbstractExtensionMatchingMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.AbstractMetadataAwareMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlHandler;

public final class FlvMediaUrlHandler
extends AbstractMetadataAwareMediaUrlHandler {
    private final String playerLocation;
    private final String newPlayerLocation;
    private MediaUrlHandler delegate = new AbstractExtensionMatchingMediaUrlHandler(){

        @Override
        protected String[] getSupportedExtensions() {
            return new String[]{"flv", "f4v", "f4p", "mp4", "m4v"};
        }

        @Override
        public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
            throw new UnsupportedOperationException();
        }
    };

    public FlvMediaUrlHandler(String playerLocation, String newPlayerLocation) {
        this.playerLocation = playerLocation;
        this.newPlayerLocation = newPlayerLocation;
        if (playerLocation == null && newPlayerLocation == null) {
            throw new IllegalStateException("FLV Player location must be set");
        }
    }

    @Override
    public boolean recognises(String url) {
        return this.delegate.recognises(url) || url.startsWith("rtmp://");
    }

    @Override
    public String getHtmlInner(String url, Map<String, Object> parameters) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", url);
        if (this.newPlayerLocation != null && !url.startsWith("rtmp://")) {
            model.put("newPlayer", true);
            model.put("playerLocation", this.newPlayerLocation);
        } else {
            model.put("newPlayer", false);
            model.put("playerLocation", this.playerLocation);
        }
        model.put("preload", "metadata");
        if (parameters.containsKey("preload")) {
            model.put("preload", parameters.get("preload"));
        }
        model.putAll(parameters);
        if (!parameters.containsKey("previewimage")) {
            model.put("previewimage", "");
        }
        if (!parameters.containsKey("captions")) {
            model.put("captions", "");
        }
        if (!parameters.containsKey("stretching")) {
            model.put("stretching", "fill");
        }
        return this.renderTemplate("media/flv.ftl", model);
    }
}

