/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.Map;
import java.util.regex.Matcher;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.AbstractSquareTagTransformer;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;

public final class PageSummaryTagTextTransformer
extends AbstractSquareTagTransformer {
    public static final String SUMMARY_DIV_ID = "sbr_pagesummary";
    private static final String[] ALLOWED_PARAMETERS = new String[]{"visible"};

    public PageSummaryTagTextTransformer() {
        super("page-summary", true, true, true);
    }

    @Override
    protected boolean isTagGeneratesHead() {
        return false;
    }

    @Override
    protected TextPatternTransformer.Callback getCallback() {
        return new TextPatternTransformer.Callback(){

            @Override
            public String transform(String input, MutableContent mc) {
                Matcher matcher = PageSummaryTagTextTransformer.this.getTagPattern().matcher(input);
                if (!matcher.matches()) {
                    throw new IllegalStateException("Failed to match summary tag, but shouldn't be here if it didn't");
                }
                Map<String, Object> parameters = PageSummaryTagTextTransformer.this.getParameters(matcher);
                String contents = PageSummaryTagTextTransformer.this.getContents(matcher);
                boolean visible = true;
                if (parameters.containsKey("visible")) {
                    visible = !((String)parameters.get("visible")).equalsIgnoreCase("false");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<div id=\"");
                sb.append(PageSummaryTagTextTransformer.SUMMARY_DIV_ID);
                sb.append("\"");
                if (!visible) {
                    sb.append(" style=\"display:none;\"");
                }
                sb.append(">");
                sb.append(contents);
                sb.append("</div>");
                return sb.toString();
            }
        };
    }

    @Override
    protected String[] getAllowedParameters() {
        return ALLOWED_PARAMETERS;
    }
}

