/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.textile2.lite;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.textile2.lite.Content;
import uk.ac.warwick.util.content.textile2.lite.TextileConstants;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public class TextileLite
implements TextileConstants,
TextTransformer {
    public final MutableContent apply(MutableContent mc) {
        String content = mc.getContent();
        content = TextileLite.replace(content, "\r\n", "\n");
        content = TextileLite.replace(content, "\t", "");
        Content textContent = new Content(content);
        mc.setContent(textContent.getContentProcessedSoFar() + this.processTextile(textContent.getRemainingContent()));
        return mc;
    }

    private String processTextile(String content) {
        int y;
        int x;
        content = content.replaceAll("&(?![#a-zA-Z0-9]+;)", "x%x%");
        content = TextileLite.replace(content, "\r\n", "\n");
        content = TextileLite.replace(content, "\t", "");
        content = content.replaceAll("\"([^\"\\(]+)\\s?(\\(([^\\)]+)\\))?\":(\\S+)([\\.,:\\?!;~\\^*_\\+@\\-\\)])(\\s|$)", "<a href=\\\"$4\\\" title=\\\"$3\\\">$1</a>$5$6");
        content = content.replaceAll("\"([^\"\\(]+)\\s?(\\(([^\\)]+)\\))?\":(\\S+)(\\s|$)", "<a href=\\\"$4\\\" title=\\\"$3\\\">$1</a>$5");
        content = content.replaceAll("(?i) href=\"((?!(http://))(?!/)(?!(https://))).*?\"", " href=\"\"");
        content = content.replaceAll("(?i) src=\"((?!(http://))(?!/)(?!(https://))).*?\"", " src=\"\"");
        for (x = 0; x < EXP_PHRASE_MODIFIER_SOURCETAGS.length; ++x) {
            for (y = 0; y <= 2; ++y) {
                content = this.doStandardTags(content, x, y);
            }
        }
        for (x = 0; x < EXP_PHRASE_MODIFIER_SOURCETAGS.length; ++x) {
            for (y = 0; y <= 2; ++y) {
                content = this.doEscapedStandardTags(content, x, y);
            }
        }
        if (TextileLite.count(content, '^') > 1) {
            content = content.replaceAll("(?!.*http://[\\S&&[^\\\"]]+\\^)(?!.*www\\.[\\S&&[^\\\"]]+\\^)([^\\\\])(?:\\^)(.*?)([^\\\\])(?:\\^)", "$1<sup>$2$3</sup>");
        }
        if (TextileLite.count(content = content.replaceAll("\\\\\\^", "\\^"), '~') > 1) {
            content = content.replaceAll("(?!.*http://[\\S&&[^\\\"]]+\\~)(?!.*www\\.[\\S&&[^\\\"]]+\\~)([^\\\\])(?:\\~)(.*?)([^\\\\])(?:\\~)", "$1<sub>$2$3</sub>");
        }
        content = content.replaceAll("\\\\\\~", "\\~");
        content = content.replaceAll("\"$", " ");
        boolean ishtml = Pattern.compile("<.*>").matcher(content).find();
        boolean inpreservation = false;
        if (!ishtml) {
            content = this.doGlyphs(content);
        } else {
            String[] segments = this.splitContent("<.*>", content);
            StringBuffer segmentBuffer = new StringBuffer();
            for (int x2 = 0; x2 < segments.length; ++x2) {
                if (segments[x2].toLowerCase().matches("<(code|pre|kbd|notextile|latex|media)>")) {
                    inpreservation = true;
                } else if (segments[x2].toLowerCase().matches("</(code|pre|kbd|notextile|latex|media)>")) {
                    inpreservation = false;
                }
                if (!Pattern.compile("<.*>").matcher(segments[x2]).find() && !inpreservation) {
                    segments[x2] = this.doGlyphs(segments[x2]);
                }
                if (inpreservation) {
                    segments[x2] = this.htmlSpecialChars(segments[x2], 2);
                    segments[x2] = TextileLite.replace(segments[x2], "&lt;pre&gt;", "<pre>");
                    segments[x2] = TextileLite.replace(segments[x2], "&lt;code&gt;", "<code>");
                    segments[x2] = TextileLite.replace(segments[x2], "&lt;notextile&gt;", "<notextile>");
                }
                segmentBuffer.append(segments[x2]);
            }
            content = segmentBuffer.toString();
        }
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        if (content.startsWith("\n") || content.startsWith("\t")) {
            content = content.substring(1, content.length());
        }
        if (content.indexOf("\n") == -1) {
            content = content.replaceAll("<p>", "");
            content = content.replaceAll("</p>", "");
        }
        content = TextileLite.replace(content, "x%x%", "&#38;");
        return content;
    }

    private String doStandardTags(String content, int x, int y) {
        String prefix = "([\\W&&[^;,\\\\]]|^|_)" + EXP_PHRASE_MODIFIER_SOURCETAGS[x];
        String suffix = "";
        if (y == 0) {
            prefix = prefix + "([^\\s&&[^;,]]+?)(?<![\\\\])" + EXP_PHRASE_MODIFIER_SOURCETAGS[x];
            suffix = "$1<" + EXP_PHRASE_MODIFIER_REPLACETAGS[x] + ">$2</" + EXP_PHRASE_MODIFIER_REPLACETAGS[x] + ">$3";
        }
        if (y == 1) {
            prefix = prefix + "([^\\s&&[^;,]]+?)([^\\s&&[^;,]]+?)(?<![\\\\])" + EXP_PHRASE_MODIFIER_SOURCETAGS[x];
            suffix = "$1<" + EXP_PHRASE_MODIFIER_REPLACETAGS[x] + ">$2$3</" + EXP_PHRASE_MODIFIER_REPLACETAGS[x] + ">$4";
        }
        if (y == 2) {
            prefix = prefix + "([^\\s&&[^;,]]+?)(.+?)([^\\s&&[^;,]]+?)(?<![\\\\])" + EXP_PHRASE_MODIFIER_SOURCETAGS[x];
            suffix = "$1<" + EXP_PHRASE_MODIFIER_REPLACETAGS[x] + ">$2$3$4</" + EXP_PHRASE_MODIFIER_REPLACETAGS[x] + ">$5";
        }
        prefix = prefix + "(\\W|$|_)";
        content = content.replaceAll(prefix, suffix);
        return content;
    }

    private String doEscapedStandardTags(String content, int x, int y) {
        String prefix = "([\\W&&[^;,]]|^|_)(?:[\\\\]?+)" + EXP_PHRASE_MODIFIER_SOURCETAGS[x];
        String suffix = "";
        if (y == 0) {
            prefix = prefix + "([^\\s&&[^;,]]+?)(?:\\\\)" + EXP_PHRASE_MODIFIER_SOURCETAGS[x];
            suffix = "$1" + EXP_PHRASE_MODIFIER_SOURCETAGS[x] + "$2" + EXP_PHRASE_MODIFIER_SOURCETAGS[x] + "$3";
        }
        if (y == 1) {
            prefix = prefix + "([^\\s&&[^;,]]+?)([^\\s&&[^;,]]+?)(?:[\\\\]?+)" + EXP_PHRASE_MODIFIER_SOURCETAGS[x];
            suffix = "$1" + EXP_PHRASE_MODIFIER_SOURCETAGS[x] + "$2$3" + EXP_PHRASE_MODIFIER_SOURCETAGS[x] + "$4";
        }
        if (y == 2) {
            prefix = prefix + "([^\\s&&[^;,]]+?)(.+?)([^\\s&&[^;,]]+?)(?:[\\\\]?+)" + EXP_PHRASE_MODIFIER_SOURCETAGS[x];
            suffix = "$1" + EXP_PHRASE_MODIFIER_SOURCETAGS[x] + "$2$3$4" + EXP_PHRASE_MODIFIER_SOURCETAGS[x] + "$5";
        }
        prefix = prefix + "(\\W|$|_)";
        content = content.replaceAll(prefix, suffix);
        return content;
    }

    private String htmlSpecialChars(String origContent, int mode) {
        String content = origContent;
        content = TextileLite.replace(content, "&", "&amp;");
        if (mode != 2) {
            content = TextileLite.replace(content, "\"", "&quot;");
        }
        if (mode == 3) {
            content = TextileLite.replace(content, "'", "&#039;");
        }
        content = TextileLite.replace(content, "<", "&lt;");
        content = TextileLite.replace(content, ">", "&gt;");
        return content;
    }

    private String[] splitContent(String matchexp, String content) {
        int startAt = 0;
        ArrayList<String> tempList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(matchexp);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            tempList.add(content.substring(startAt, matcher.start()));
            tempList.add(matcher.group());
            startAt = matcher.end();
        }
        tempList.add(content.substring(startAt));
        String[] result = new String[tempList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)tempList.get(i);
        }
        return result;
    }

    private String arrayReplaceAll(String content, String[] matches, String[] replaces) {
        String result = content;
        for (int x = 0; x < matches.length; ++x) {
            String match = matches[x];
            String replace = replaces[x];
            result = result.replaceAll(match, replace);
        }
        return result;
    }

    private static String replace(String str, String pattern, String replace) {
        if (str == null || "".equals(str)) {
            return str;
        }
        if (replace == null) {
            return str;
        }
        if ("".equals(pattern)) {
            return str;
        }
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    private String doGlyphs(String content) {
        String[] glyphMatches = new String[]{"(\\w|^|\\s)( )?\\.{3}", "\\b([A-Z][A-Z0-9]{2,})\\b(\\(([^\\)]+)\\))", "(^|[^\"][>\\s])([A-Z][A-Z0-9 ]{2,})([^<a-z0-9]|$)", "(\\s)?--(\\s)?", "(\\d+)-(\\d+)", "(\\d+) ?x ?(\\d+)", "([^\\\\])(\\((TM)\\))", "(\\s+|\\A|^)(\\([R]\\))", "(\\s+|\\A|^)(\\([C]\\))"};
        String[] glyphReplacement = new String[]{"$1$2&hellip;", "<acronym title=\"$3\">$1</acronym>", "$1<span class=\"caps\">$2</span>$3", "$1&mdash;$2", "$1&ndash;$2", "$1&times;$2", "$1&trade;", "$1&reg;", "$1&copy;"};
        String stringAfterGlyphs = this.arrayReplaceAll(content, glyphMatches, glyphReplacement);
        stringAfterGlyphs = this.insertEntities(stringAfterGlyphs);
        return stringAfterGlyphs.replaceAll("\\\\(\\((C|R|TM)\\))", "$1");
    }

    private String insertEntities(String text) {
        if (text == null) {
            return null;
        }
        int originalTextLength = text.length();
        StringBuffer sb = new StringBuffer(originalTextLength * 110 / 100);
        int charsToAppend = 0;
        for (int i = 0; i < originalTextLength; ++i) {
            char c = text.charAt(i);
            String entity = TextileLite.charToEntity(c);
            if (entity == null) {
                ++charsToAppend;
                continue;
            }
            if (charsToAppend != 0) {
                sb.append(text.substring(i - charsToAppend, i));
                charsToAppend = 0;
            }
            sb.append(entity);
        }
        if (charsToAppend != 0) {
            sb.append(text.substring(originalTextLength - charsToAppend, originalTextLength));
        }
        if (sb.length() == originalTextLength) {
            return text;
        }
        return sb.toString();
    }

    private static String charToEntity(char characterToConvert) {
        switch (characterToConvert) {
            case '\u0091': {
                return "&lsquo;";
            }
            case '\u0092': {
                return "&rsquo;";
            }
            case '\u0096': {
                return "&ndash;";
            }
            case '-': {
                return "&ndash;";
            }
            case '\u00a0': {
                return "&nbsp;";
            }
            case '\u00a1': {
                return "&iexcl;";
            }
            case '\u00a2': {
                return "&cent;";
            }
            case '\u00a3': {
                return "&pound;";
            }
            case '\u00a4': {
                return "&curren;";
            }
            case '\u00a5': {
                return "&yen;";
            }
            case '\u00a6': {
                return "&brvbar;";
            }
            case '\u00a7': {
                return "&sect;";
            }
            case '\u00a8': {
                return "&uml;";
            }
            case '\u00a9': {
                return "&copy;";
            }
            case '\u00aa': {
                return "&ordf;";
            }
            case '\u00ab': {
                return "&laquo;";
            }
            case '\u00ac': {
                return "&not;";
            }
            case '\u00ad': {
                return "&shy;";
            }
            case '\u00ae': {
                return "&reg;";
            }
            case '\u00af': {
                return "&macr;";
            }
            case '\u00b0': {
                return "&deg;";
            }
            case '\u00b1': {
                return "&plusmn;";
            }
            case '\u00b2': {
                return "&sup2;";
            }
            case '\u00b3': {
                return "&sup3;";
            }
            case '\u00b4': {
                return "&acute;";
            }
            case '\u00b5': {
                return "&micro;";
            }
            case '\u00b6': {
                return "&para;";
            }
            case '\u00b7': {
                return "&middot;";
            }
            case '\u00b8': {
                return "&cedil;";
            }
            case '\u00b9': {
                return "&sup1;";
            }
            case '\u00ba': {
                return "&ordm;";
            }
            case '\u00bb': {
                return "&raquo;";
            }
            case '\u00bc': {
                return "&frac14;";
            }
            case '\u00bd': {
                return "&frac12;";
            }
            case '\u00be': {
                return "&frac34;";
            }
            case '\u00bf': {
                return "&iquest;";
            }
            case '\u00c0': {
                return "&Agrave;";
            }
            case '\u00c1': {
                return "&Aacute;";
            }
            case '\u00c2': {
                return "&Acirc;";
            }
            case '\u00c3': {
                return "&Atilde;";
            }
            case '\u00c4': {
                return "&Auml;";
            }
            case '\u00c5': {
                return "&Aring;";
            }
            case '\u00c6': {
                return "&AElig;";
            }
            case '\u00c7': {
                return "&Ccedil;";
            }
            case '\u00c8': {
                return "&Egrave;";
            }
            case '\u00c9': {
                return "&Eacute;";
            }
            case '\u00ca': {
                return "&Ecirc;";
            }
            case '\u00cb': {
                return "&Euml;";
            }
            case '\u00cc': {
                return "&Igrave;";
            }
            case '\u00cd': {
                return "&Iacute;";
            }
            case '\u00ce': {
                return "&Icirc;";
            }
            case '\u00cf': {
                return "&Iuml;";
            }
            case '\u00d0': {
                return "&ETH;";
            }
            case '\u00d1': {
                return "&Ntilde;";
            }
            case '\u00d2': {
                return "&Ograve;";
            }
            case '\u00d3': {
                return "&Oacute;";
            }
            case '\u00d4': {
                return "&Ocirc;";
            }
            case '\u00d5': {
                return "&Otilde;";
            }
            case '\u00d6': {
                return "&Ouml;";
            }
            case '\u00d7': {
                return "&times;";
            }
            case '\u00d8': {
                return "&Oslash;";
            }
            case '\u00d9': {
                return "&Ugrave;";
            }
            case '\u00da': {
                return "&Uacute;";
            }
            case '\u00db': {
                return "&Ucirc;";
            }
            case '\u00dc': {
                return "&Uuml;";
            }
            case '\u00dd': {
                return "&Yacute;";
            }
            case '\u00de': {
                return "&THORN;";
            }
            case '\u00df': {
                return "&szlig;";
            }
            case '\u00e0': {
                return "&agrave;";
            }
            case '\u00e1': {
                return "&aacute;";
            }
            case '\u00e2': {
                return "&acirc;";
            }
            case '\u00e3': {
                return "&atilde;";
            }
            case '\u00e4': {
                return "&auml;";
            }
            case '\u00e5': {
                return "&aring;";
            }
            case '\u00e6': {
                return "&aelig;";
            }
            case '\u00e7': {
                return "&ccedil;";
            }
            case '\u00e8': {
                return "&egrave;";
            }
            case '\u00e9': {
                return "&eacute;";
            }
            case '\u00ea': {
                return "&ecirc;";
            }
            case '\u00eb': {
                return "&euml;";
            }
            case '\u00ec': {
                return "&igrave;";
            }
            case '\u00ed': {
                return "&iacute;";
            }
            case '\u00ee': {
                return "&icirc;";
            }
            case '\u00ef': {
                return "&iuml;";
            }
            case '\u00f0': {
                return "&eth;";
            }
            case '\u00f1': {
                return "&ntilde;";
            }
            case '\u00f2': {
                return "&ograve;";
            }
            case '\u00f3': {
                return "&oacute;";
            }
            case '\u00f4': {
                return "&ocirc;";
            }
            case '\u00f5': {
                return "&otilde;";
            }
            case '\u00f6': {
                return "&ouml;";
            }
            case '\u00f7': {
                return "&divide;";
            }
            case '\u00f8': {
                return "&oslash;";
            }
            case '\u00f9': {
                return "&ugrave;";
            }
            case '\u00fa': {
                return "&uacute;";
            }
            case '\u00fb': {
                return "&ucirc;";
            }
            case '\u00fc': {
                return "&uuml;";
            }
            case '\u00fd': {
                return "&yacute;";
            }
            case '\u00fe': {
                return "&thorn;";
            }
            case '\u00ff': {
                return "&yuml;";
            }
            case '\u0152': {
                return "&OElig;";
            }
            case '\u0153': {
                return "&oelig;";
            }
            case '\u0160': {
                return "&Scaron;";
            }
            case '\u0161': {
                return "&scaron;";
            }
            case '\u0178': {
                return "&Yuml;";
            }
            case '\u0192': {
                return "&fnof;";
            }
            case '\u02c6': {
                return "&circ;";
            }
            case '\u02dc': {
                return "&tilde;";
            }
            case '\u0391': {
                return "&Alpha;";
            }
            case '\u0392': {
                return "&Beta;";
            }
            case '\u0393': {
                return "&Gamma;";
            }
            case '\u0394': {
                return "&Delta;";
            }
            case '\u0395': {
                return "&Epsilon;";
            }
            case '\u0396': {
                return "&Zeta;";
            }
            case '\u0397': {
                return "&Eta;";
            }
            case '\u0398': {
                return "&Theta;";
            }
            case '\u0399': {
                return "&Iota;";
            }
            case '\u039a': {
                return "&Kappa;";
            }
            case '\u039b': {
                return "&Lambda;";
            }
            case '\u039c': {
                return "&Mu;";
            }
            case '\u039d': {
                return "&Nu;";
            }
            case '\u039e': {
                return "&Xi;";
            }
            case '\u039f': {
                return "&Omicron;";
            }
            case '\u03a0': {
                return "&Pi;";
            }
            case '\u03a1': {
                return "&Rho;";
            }
            case '\u03a3': {
                return "&Sigma;";
            }
            case '\u03a4': {
                return "&Tau;";
            }
            case '\u03a5': {
                return "&Upsilon;";
            }
            case '\u03a6': {
                return "&Phi;";
            }
            case '\u03a7': {
                return "&Chi;";
            }
            case '\u03a8': {
                return "&Psi;";
            }
            case '\u03a9': {
                return "&Omega;";
            }
            case '\u03b1': {
                return "&alpha;";
            }
            case '\u03b2': {
                return "&beta;";
            }
            case '\u03b3': {
                return "&gamma;";
            }
            case '\u03b4': {
                return "&delta;";
            }
            case '\u03b5': {
                return "&epsilon;";
            }
            case '\u03b6': {
                return "&zeta;";
            }
            case '\u03b7': {
                return "&eta;";
            }
            case '\u03b8': {
                return "&theta;";
            }
            case '\u03b9': {
                return "&iota;";
            }
            case '\u03ba': {
                return "&kappa;";
            }
            case '\u03bb': {
                return "&lambda;";
            }
            case '\u03bc': {
                return "&mu;";
            }
            case '\u03bd': {
                return "&nu;";
            }
            case '\u03be': {
                return "&xi;";
            }
            case '\u03bf': {
                return "&omicron;";
            }
            case '\u03c0': {
                return "&pi;";
            }
            case '\u03c1': {
                return "&rho;";
            }
            case '\u03c2': {
                return "&sigmaf;";
            }
            case '\u03c3': {
                return "&sigma;";
            }
            case '\u03c4': {
                return "&tau;";
            }
            case '\u03c5': {
                return "&upsilon;";
            }
            case '\u03c6': {
                return "&phi;";
            }
            case '\u03c7': {
                return "&chi;";
            }
            case '\u03c8': {
                return "&psi;";
            }
            case '\u03c9': {
                return "&omega;";
            }
            case '\u03d1': {
                return "&thetasym;";
            }
            case '\u03d2': {
                return "&upsih;";
            }
            case '\u03d6': {
                return "&piv;";
            }
            case '\u2002': {
                return "&ensp;";
            }
            case '\u2003': {
                return "&emsp;";
            }
            case '\u2009': {
                return "&thinsp;";
            }
            case '\u200c': {
                return "&zwnj;";
            }
            case '\u200d': {
                return "&zwj;";
            }
            case '\u200e': {
                return "&lrm;";
            }
            case '\u200f': {
                return "&rlm;";
            }
            case '\u2013': {
                return "&ndash;";
            }
            case '\u2014': {
                return "&mdash;";
            }
            case '\u2018': {
                return "&lsquo;";
            }
            case '\u2019': {
                return "&rsquo;";
            }
            case '\u201a': {
                return "&sbquo;";
            }
            case '\u201c': {
                return "&ldquo;";
            }
            case '\u201d': {
                return "&rdquo;";
            }
            case '\u201e': {
                return "&bdquo;";
            }
            case '\u2020': {
                return "&dagger;";
            }
            case '\u2021': {
                return "&Dagger;";
            }
            case '\u2022': {
                return "&bull;";
            }
            case '\u2026': {
                return "&hellip;";
            }
            case '\u2030': {
                return "&permil;";
            }
            case '\u2032': {
                return "&prime;";
            }
            case '\u2033': {
                return "&Prime;";
            }
            case '\u2039': {
                return "&lsaquo;";
            }
            case '\u203a': {
                return "&rsaquo;";
            }
            case '\u203e': {
                return "&oline;";
            }
            case '\u2044': {
                return "&frasl;";
            }
            case '\u20ac': {
                return "&euro;";
            }
            case '\u2111': {
                return "&image;";
            }
            case '\u2118': {
                return "&weierp;";
            }
            case '\u211c': {
                return "&real;";
            }
            case '\u2122': {
                return "&trade;";
            }
            case '\u2135': {
                return "&alefsym;";
            }
            case '\u2190': {
                return "&larr;";
            }
            case '\u2191': {
                return "&uarr;";
            }
            case '\u2192': {
                return "&rarr;";
            }
            case '\u2193': {
                return "&darr;";
            }
            case '\u2194': {
                return "&harr;";
            }
            case '\u21b5': {
                return "&crarr;";
            }
            case '\u21d0': {
                return "&lArr;";
            }
            case '\u21d1': {
                return "&uArr;";
            }
            case '\u21d2': {
                return "&rArr;";
            }
            case '\u21d3': {
                return "&dArr;";
            }
            case '\u21d4': {
                return "&hArr;";
            }
            case '\u2200': {
                return "&forall;";
            }
            case '\u2202': {
                return "&part;";
            }
            case '\u2203': {
                return "&exist;";
            }
            case '\u2205': {
                return "&empty;";
            }
            case '\u2207': {
                return "&nabla;";
            }
            case '\u2208': {
                return "&isin;";
            }
            case '\u2209': {
                return "&notin;";
            }
            case '\u220b': {
                return "&ni;";
            }
            case '\u220f': {
                return "&prod;";
            }
            case '\u2211': {
                return "&sum;";
            }
            case '\u2212': {
                return "&minus;";
            }
            case '\u2217': {
                return "&lowast;";
            }
            case '\u221a': {
                return "&radic;";
            }
            case '\u221d': {
                return "&prop;";
            }
            case '\u221e': {
                return "&infin;";
            }
            case '\u2220': {
                return "&ang;";
            }
            case '\u2227': {
                return "&and;";
            }
            case '\u2228': {
                return "&or;";
            }
            case '\u2229': {
                return "&cap;";
            }
            case '\u222a': {
                return "&cup;";
            }
            case '\u222b': {
                return "&int;";
            }
            case '\u2234': {
                return "&there4;";
            }
            case '\u223c': {
                return "&sim;";
            }
            case '\u2245': {
                return "&cong;";
            }
            case '\u2248': {
                return "&asymp;";
            }
            case '\u2260': {
                return "&ne;";
            }
            case '\u2261': {
                return "&equiv;";
            }
            case '\u2264': {
                return "&le;";
            }
            case '\u2265': {
                return "&ge;";
            }
            case '\u2282': {
                return "&sub;";
            }
            case '\u2283': {
                return "&sup;";
            }
            case '\u2284': {
                return "&nsub;";
            }
            case '\u2286': {
                return "&sube;";
            }
            case '\u2287': {
                return "&supe;";
            }
            case '\u2295': {
                return "&oplus;";
            }
            case '\u2297': {
                return "&otimes;";
            }
            case '\u22a5': {
                return "&perp;";
            }
            case '\u22c5': {
                return "&sdot;";
            }
            case '\u2308': {
                return "&lceil;";
            }
            case '\u2309': {
                return "&rceil;";
            }
            case '\u230a': {
                return "&lfloor;";
            }
            case '\u230b': {
                return "&rfloor;";
            }
            case '\u2329': {
                return "&lang;";
            }
            case '\u232a': {
                return "&rang;";
            }
            case '\u25ca': {
                return "&loz;";
            }
            case '\u2660': {
                return "&spades;";
            }
            case '\u2663': {
                return "&clubs;";
            }
            case '\u2665': {
                return "&hearts;";
            }
            case '\u2666': {
                return "&diams;";
            }
        }
        return null;
    }

    private static int count(String str, char c) {
        int index = 0;
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            ++index;
        }
        return index;
    }
}

