/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.textile2;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.textile2.TextileConfiguration;
import uk.ac.warwick.util.content.textile2.TextileTextTransformer;
import uk.ac.warwick.util.content.textile2.TransformationOptions;
import uk.ac.warwick.util.content.textile2.TransformerFeature;
import uk.ac.warwick.util.content.textile2.jruby.JRubyTextileTextTransformer;
import uk.ac.warwick.util.content.texttransformers.BadLinkRemovingTransformer;
import uk.ac.warwick.util.content.texttransformers.CompositeTextTransformer;
import uk.ac.warwick.util.content.texttransformers.CustomEscapingTransformer;
import uk.ac.warwick.util.content.texttransformers.EntityConvertingTransformer;
import uk.ac.warwick.util.content.texttransformers.EscapeHtmlCommentsTransformer;
import uk.ac.warwick.util.content.texttransformers.EscapeScriptTagsTransformer;
import uk.ac.warwick.util.content.texttransformers.LatexTextTransformer;
import uk.ac.warwick.util.content.texttransformers.NoFollowLinkTransformer;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;
import uk.ac.warwick.util.content.texttransformers.TidyLineBreaksTransformer;
import uk.ac.warwick.util.content.texttransformers.TildeLinksConvertingTransformer;
import uk.ac.warwick.util.content.texttransformers.media.AudioMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.AviMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.FlvMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlTransformer;
import uk.ac.warwick.util.content.texttransformers.media.MetacafeMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.PreziMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.QuickTimeMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.StandardFlashMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.VimeoMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.YouTubeMediaUrlHandler;

public final class Textile2
implements TextTransformer {
    public static final EnumSet<TransformerFeature> DEFAULT_FEATURESET = EnumSet.of(TransformerFeature.backslashes, TransformerFeature.latex, TransformerFeature.media, TransformerFeature.textilise, TransformerFeature.removeJsLinks);
    public static final EnumSet<TransformationOptions> DEFAULT_OPTIONS = EnumSet.noneOf(TransformationOptions.class);
    private final EnumSet<TransformerFeature> features;
    private final EnumSet<TransformationOptions> options;
    private TextTransformer transformer;

    public Textile2() {
        this(null, DEFAULT_FEATURESET, DEFAULT_OPTIONS);
    }

    public Textile2(EnumSet<TransformerFeature> features) {
        this(null, features, DEFAULT_OPTIONS);
    }

    public Textile2(EnumSet<TransformerFeature> features, EnumSet<TransformationOptions> options) {
        this(null, features, options);
    }

    public Textile2(boolean addNoFollow) {
        this(addNoFollow, DEFAULT_OPTIONS);
    }

    public Textile2(boolean addNoFollow, EnumSet<TransformationOptions> options) {
        EnumSet<TransformerFeature> theFeatures = EnumSet.copyOf(DEFAULT_FEATURESET);
        if (addNoFollow) {
            theFeatures.add(TransformerFeature.noFollowLinks);
        }
        this.features = theFeatures;
        this.options = options == null ? DEFAULT_OPTIONS : options;
        this.setupTransformers(null);
    }

    public Textile2(String textile2ServiceLocation) {
        this(textile2ServiceLocation, DEFAULT_FEATURESET, DEFAULT_OPTIONS);
    }

    public Textile2(String textile2ServiceLocation, EnumSet<TransformerFeature> features, EnumSet<TransformationOptions> options) {
        this.features = features == null ? DEFAULT_FEATURESET : features;
        this.options = options == null ? DEFAULT_OPTIONS : options;
        this.setupTransformers(textile2ServiceLocation);
    }

    private void setupTransformers(String textile2ServiceLocation) {
        ArrayList<TextTransformer> transformers = new ArrayList<TextTransformer>();
        transformers.add(new TidyLineBreaksTransformer());
        transformers.add(new EscapeHtmlCommentsTransformer());
        transformers.add(new EscapeScriptTagsTransformer());
        if (this.features.contains((Object)TransformerFeature.backslashes)) {
            transformers.add(new CustomEscapingTransformer());
        }
        transformers.add(new EntityConvertingTransformer());
        transformers.add(new TildeLinksConvertingTransformer());
        if (this.features.contains((Object)TransformerFeature.media)) {
            TextileConfiguration config = TextileConfiguration.getInstance();
            HashMap<String, MediaUrlHandler> mediaHandlers = new HashMap<String, MediaUrlHandler>();
            mediaHandlers.put("audio", new AudioMediaUrlHandler(config.getWimpyPlayerLocation(), config.getAlternativeMp3PlayerLocation(), this.options));
            mediaHandlers.put("youtube", new YouTubeMediaUrlHandler());
            mediaHandlers.put("quicktime", new QuickTimeMediaUrlHandler(config.getQtPreviewImage()));
            mediaHandlers.put("avi", new AviMediaUrlHandler(config.getWmPreviewImage()));
            mediaHandlers.put("flv", new FlvMediaUrlHandler(config.getFlvPlayerLocation(), config.getNewFlvPlayerLocation()));
            mediaHandlers.put("flash", new StandardFlashMediaUrlHandler());
            mediaHandlers.put("metacafe", new MetacafeMediaUrlHandler());
            mediaHandlers.put("vimeo", new VimeoMediaUrlHandler());
            mediaHandlers.put("prezi", new PreziMediaUrlHandler());
            transformers.add(new MediaUrlTransformer(mediaHandlers, config.getCloseButtonImgUrl()));
        }
        if (this.features.contains((Object)TransformerFeature.latex)) {
            transformers.add(new LatexTextTransformer(TextileConfiguration.getInstance().getLatexLocation()));
        }
        if (this.features.contains((Object)TransformerFeature.textilise)) {
            JRubyTextileTextTransformer jrubyTransformer = JRubyTextileTextTransformer.getInstance();
            if (jrubyTransformer == null) {
                transformers.add(new TextileTextTransformer(textile2ServiceLocation));
            } else {
                jrubyTransformer.setHardBreaks(true);
                transformers.add(jrubyTransformer);
            }
        }
        if (this.features.contains((Object)TransformerFeature.removeJsLinks)) {
            transformers.add(new BadLinkRemovingTransformer());
        }
        if (this.features.contains((Object)TransformerFeature.noFollowLinks)) {
            transformers.add(new NoFollowLinkTransformer());
        }
        this.transformer = new CompositeTextTransformer(transformers);
    }

    public MutableContent apply(MutableContent content) {
        return (MutableContent)this.transformer.apply(content);
    }
}

