/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.cleaner;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import uk.ac.warwick.util.content.cleaner.CleanerWriter;
import uk.ac.warwick.util.content.cleaner.TagAndAttributeFilter;

public final class TagAndAttributeFilterImpl
implements TagAndAttributeFilter {
    private static final Pattern ALIGN_STYLE = Pattern.compile("\\s*text-align:\\s*[a-z]+;?\\s*", 2);
    private static final Set<String> disallowedTags = CleanerWriter.toSet("u", "font", "placetype", "placename", "place", "city", "country-region", "time", "date", "notextile", "stockticker", "personname", "shapetype", "stroke", "formulas", "f", "lock", "shape", "imagedata", "smarttagtype", "big");
    private static final Set<String> disallowedNoAttributesTags = CleanerWriter.toSet("span", "blockquote");
    private static final Set<String> disallowedAttributesAllTags = CleanerWriter.toSet("mce_keep", "_mce_keep", "data-mce-keep", "onerror", "onsuccess", "onfailure", "sizset", "sizcache");
    private static final Set<String> allowedEmptyAttributes = CleanerWriter.toSet("alt");
    private static final Set<String> disallowNested = CleanerWriter.toSet("b", "i", "strong", "em", "p", "sup", "sub", "script", "code", "pre", "a", "form");
    private static final Set<String> disallowedSelfAttributes = CleanerWriter.toSet("background", "width", "height", "src", "href", "colspan", "align");
    private static final Map<String, Set<String>> disallowedAttributes = new HashMap<String, Set<String>>();
    private Stack<String> removedNestedTags = new Stack();
    private boolean allowJavascriptHandlers = true;

    @Override
    public boolean isAttributeAllowed(String tagName, String attributeName) {
        return this.isAttributeAllowed(tagName, attributeName, "");
    }

    @Override
    public boolean isAttributeAllowed(String tagName, String attributeName, String attributeValue) {
        boolean allowed = true;
        allowed &= this.isAllowedAttributeForTag(tagName, attributeName, attributeValue);
        allowed &= this.isAllowedAttributeForAllTags(attributeName);
        allowed &= this.isAllowedBlankAttribute(attributeName, attributeValue);
        allowed &= this.isAllowedAttributeValue(attributeName, attributeValue);
        if (attributeName.equalsIgnoreCase("class")) {
            allowed &= this.isAllowedClassName(tagName, attributeValue);
        } else if (attributeName.equalsIgnoreCase("id")) {
            allowed &= this.isAllowedId(tagName, attributeValue);
        } else if (attributeName.equalsIgnoreCase("style")) {
            allowed &= this.isAllowedStyle(tagName, attributeValue);
        }
        return allowed;
    }

    private boolean isAllowedClassName(String tagName, String className) {
        if (className.startsWith("mce") || className.startsWith("_mce") || className.startsWith("Mso") || className.startsWith("Apple-")) {
            return false;
        }
        return !tagName.equalsIgnoreCase("span") || !className.matches("style\\d+");
    }

    private boolean isAllowedId(String tagName, String id) {
        return !id.startsWith("mce_") && !id.startsWith("_mce");
    }

    private boolean isAllowedStyle(String tagName, String style) {
        return style.indexOf("url(background)") == -1;
    }

    private boolean isAllowedAttributeValue(String attributeName, String attributeValue) {
        return !disallowedSelfAttributes.contains(attributeName.toLowerCase()) || !attributeName.equalsIgnoreCase(attributeValue);
    }

    private boolean isAllowedBlankAttribute(String attributeName, String attributeValue) {
        boolean canBeBlank = allowedEmptyAttributes.contains(attributeName);
        return !attributeValue.equals("") || canBeBlank;
    }

    private boolean isAllowedAttributeForAllTags(String attributeName) {
        for (String attribute : disallowedAttributesAllTags) {
            if (!attribute.equalsIgnoreCase(attributeName) && !("mce_" + attribute).equalsIgnoreCase(attributeName) && !("_mce_" + attribute).equalsIgnoreCase(attributeName) && !("data-mce-" + attribute).equalsIgnoreCase(attributeName)) continue;
            return false;
        }
        return this.isAllowJavascriptHandlers() || !attributeName.toLowerCase().startsWith("on");
    }

    private boolean isAllowedAttributeForTag(String tagName, String attributeName, String attributeValue) {
        if (this.isAlignStyle(tagName, attributeValue) || this.isStrikethrough(tagName, attributeName, attributeValue)) {
            return true;
        }
        for (String tag : disallowedAttributes.keySet()) {
            if (!tagName.equals(tag)) continue;
            for (String attribute : disallowedAttributes.get(tag)) {
                if (!attributeName.equals(attribute) && !attributeName.equals("mce_" + attribute) && !attributeName.equals("_mce_" + attribute) && !attributeName.equals("data-mce-" + attribute)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isStrikethrough(String tagName, String attributeName, String attributeValue) {
        return tagName.equals("span") && attributeName.equals("style") && CleanerWriter.STRIKETHROUGH_CSS.matcher(attributeValue).matches();
    }

    private boolean isAlignStyle(String tagName, String attributeValue) {
        return !tagName.equals("span") && ALIGN_STYLE.matcher(attributeValue).matches();
    }

    private boolean isTagAllowed(String tagName, boolean hasAtts, boolean closingTag) {
        boolean result = true;
        if (disallowedTags.contains(tagName)) {
            result = false;
        }
        if (!hasAtts && !closingTag && disallowedNoAttributesTags.contains(tagName)) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean isTagAllowed(String tagName, Stack<String> tagStack, boolean isClosingTag, Attributes atts) {
        boolean hasAttributes = this.hasAttributes(tagName, atts);
        boolean allowed = this.isTagAllowed(tagName, hasAttributes, isClosingTag);
        if (disallowNested.contains(tagName) && (isClosingTag && !this.removedNestedTags.isEmpty() && this.removedNestedTags.pop().equals(tagName) || !isClosingTag && tagStack.contains(tagName))) {
            allowed = false;
            if (!isClosingTag) {
                this.removedNestedTags.push(tagName);
            }
        }
        return allowed;
    }

    private boolean hasAttributes(String tagName, Attributes atts) {
        if (atts == null) {
            return false;
        }
        boolean result = false;
        int attCount = atts.getLength();
        if (attCount > 0) {
            for (int i = 0; i < attCount; ++i) {
                String value;
                String attName = atts.getLocalName(i);
                if (!this.isAttributeAllowed(tagName, attName, value = atts.getValue(i))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isAllowJavascriptHandlers() {
        return this.allowJavascriptHandlers;
    }

    @Override
    public void setAllowJavascriptHandlers(boolean allowJavascriptHandlers) {
        this.allowJavascriptHandlers = allowJavascriptHandlers;
    }

    @Override
    public void setAllowBlockquoteWithNoAttributes(boolean allowBlockquoteWithNoAttributes) {
        if (!allowBlockquoteWithNoAttributes && !disallowedNoAttributesTags.contains("blockquote")) {
            disallowedNoAttributesTags.add("blockquote");
        } else {
            disallowedNoAttributesTags.remove("blockquote");
        }
    }

    static {
        disallowedAttributes.put("span", CleanerWriter.toSet("style", "lang"));
        disallowedAttributes.put("h1", CleanerWriter.toSet("style"));
        disallowedAttributes.put("h2", CleanerWriter.toSet("style"));
        disallowedAttributes.put("h3", CleanerWriter.toSet("style"));
        disallowedAttributes.put("h4", CleanerWriter.toSet("style"));
        disallowedAttributes.put("h5", CleanerWriter.toSet("style"));
        disallowedAttributes.put("h6", CleanerWriter.toSet("style"));
        disallowedAttributes.put("b", CleanerWriter.toSet("style"));
        disallowedAttributes.put("i", CleanerWriter.toSet("style"));
        disallowedAttributes.put("p", CleanerWriter.toSet("style"));
        disallowedAttributes.put("strong", CleanerWriter.toSet("style"));
        disallowedAttributes.put("em", CleanerWriter.toSet("style"));
    }
}

