/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.concurrency.CompletionServiceProvider;
import uk.ac.warwick.util.concurrency.TaskExecutionCompletionService;

public final class TaskExecutionService
implements ExecutorService,
CompletionServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecutionService.class);
    private final ExecutorService delegate;

    public TaskExecutionService() {
        this(Executors.newCachedThreadPool());
    }

    public TaskExecutionService(int threadLimit) {
        this(Executors.newFixedThreadPool(threadLimit));
    }

    public TaskExecutionService(ExecutorService executor) {
        this.delegate = executor;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        LOGGER.debug("Terminating all tasks (timeout " + timeout + unit.toString() + ")");
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        LOGGER.debug("Invoking " + tasks.size() + " tasks: " + tasks);
        return this.delegate.invokeAll(new ArrayList<Callable<T>>(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        LOGGER.debug("Invoking " + tasks.size() + " tasks: " + tasks + " with " + timeout + unit.toString() + " timeout");
        return this.delegate.invokeAll(new ArrayList<Callable<T>>(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        LOGGER.debug("Invoking " + tasks.size() + " tasks: " + tasks);
        return this.delegate.invokeAny(new ArrayList<Callable<T>>(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        LOGGER.debug("Invoking " + tasks.size() + " tasks: " + tasks + " with " + timeout + unit.toString() + " timeout");
        try {
            return this.delegate.invokeAny(new ArrayList<Callable<T>>(tasks), timeout, unit);
        }
        catch (TimeoutException e) {
            throw new ExecutionException("The task timed out", e);
        }
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        LOGGER.info("Shutting down execution service");
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        LOGGER.info("Shutting down execution service IMMEDIATELY");
        return this.delegate.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        LOGGER.debug("Submitting task " + task + " to execution pool");
        return this.delegate.submit(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        LOGGER.debug("Submitting task " + task + " to execution pool");
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        LOGGER.debug("Submitting task " + task + " to execution pool");
        return this.delegate.submit(task, result);
    }

    @Override
    public void execute(Runnable command) {
        LOGGER.debug("Executing command " + command);
        this.delegate.execute(command);
    }

    public <T> TaskExecutionCompletionService<T> newCompletionService() {
        return new TaskExecutionCompletionService(this);
    }
}

