/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections.google;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Iterator;

public final class InternalIterable<T>
implements Iterable<T> {
    private Iterable<T> delegate;

    public InternalIterable(Iterable<T> delegateIterable) {
        this.delegate = delegateIterable;
    }

    public InternalIterable<T> filter(Predicate<? super T> predicate) {
        return new InternalIterable<T>(Iterables.filter(this.delegate, predicate));
    }

    public <X> InternalIterable<X> transform(Function<T, X> transform) {
        return new InternalIterable<T>(Iterables.transform(this.delegate, transform));
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public static <X> InternalIterable<X> of(Iterable<X> source) {
        return new InternalIterable<X>(source);
    }

    public boolean all(Predicate<T> test) {
        return Iterables.all(this.delegate, test);
    }

    public boolean any(Predicate<T> test) {
        return Iterables.any(this.delegate, test);
    }

    public InternalIterable<T> sort(Ordering<T> comparator) {
        return new InternalIterable<T>(comparator.sortedCopy(this.delegate));
    }

    public T find(Predicate<? super T> match) {
        return (T)Iterables.find(this.delegate, match);
    }

    public <F> F inject(F initialMemo, Injector<F, T> injector) {
        F memo = initialMemo;
        for (T element : this.delegate) {
            memo = injector.apply(memo, element);
        }
        return memo;
    }

    public static interface Injector<F, T> {
        public F apply(F var1, T var2);
    }
}

