/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.warwick.util.collections.Pair;

public class PairIterator<L, R>
implements Iterator<Pair<L, R>> {
    private final Iterator<L> leftIterator;
    private final Iterator<R> rightIterator;

    public PairIterator(Iterator<L> left, Iterator<R> right) {
        this.leftIterator = left;
        this.rightIterator = right;
    }

    public PairIterator(Iterable<L> left, Iterable<R> right) {
        this.leftIterator = left.iterator();
        this.rightIterator = right.iterator();
    }

    public static <E, F> Iterable<Pair<E, F>> of(final Iterable<E> left, final Iterable<F> right) {
        return new Iterable<Pair<E, F>>(){

            @Override
            public Iterator<Pair<E, F>> iterator() {
                return new PairIterator(left, right);
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.leftIterator.hasNext() || this.rightIterator.hasNext();
    }

    @Override
    public Pair<L, R> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object left = this.leftIterator.hasNext() ? (Object)this.leftIterator.next() : null;
        Object right = this.rightIterator.hasNext() ? (Object)this.rightIterator.next() : null;
        return Pair.of(left, right);
    }

    @Override
    public void remove() {
        this.leftIterator.remove();
        this.rightIterator.remove();
    }
}

